/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui.response;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.items.Mentionable;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.ui.response.ResponseElement;
import de.kaleidox.util.markers.NamedItem;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class YesNo
extends ResponseElement<Boolean> {
    private static final String EMOJI_YES = "\u2705";
    private static final String EMOJI_NO = "\u274c";
    private EmbedDraft.Field field;

    public YesNo(String name, MessageReciever parent, Supplier<Embed.Builder> embedBaseSupplier, Predicate<User> userCanRespond) {
        super(name, parent, embedBaseSupplier, userCanRespond);
    }

    @Override
    public CompletableFuture<NamedItem<Boolean>> build() {
        Embed.Builder embed = (Embed.Builder)this.embedBaseSupplier.get();
        embed.setDescription("Yes/No question:").setTimestampNow();
        if (this.field != null) {
            embed.addField(this.field);
        }
        CompletableFuture<NamedItem<Boolean>> future = new CompletableFuture<NamedItem<Boolean>>();
        this.parent.sendMessage(embed.build()).thenAcceptAsync(message -> {
            this.affiliateMessages.add(message);
            message.addReaction(EMOJI_YES);
            message.addReaction(EMOJI_NO);
            message.attachListener((Listener)((ReactionAddListener)event -> {
                this.affiliateMessages.add(event.getMessage());
                Emoji emoji = event.getEmoji();
                User user = event.getUser();
                if (!user.isYourself()) {
                    if (this.userCanRespond.test(user) && emoji.toUnicodeEmoji().isPresent()) {
                        switch (emoji.toUnicodeEmoji().map(Mentionable::getMentionTag).get()) {
                            case "\u2705": {
                                future.complete(new NamedItem(this.name, (Object)true));
                                break;
                            }
                            case "\u274c": {
                                future.complete(new NamedItem(this.name, (Object)false));
                                break;
                            }
                            default: {
                                event.getMessage().removeReactionsByEmoji(new Emoji[]{emoji});
                                break;
                            }
                        }
                    } else {
                        event.getMessage().removeReactionsByEmoji(new Emoji[]{emoji});
                    }
                }
            }));
            this.parent.getDiscord().getThreadPool().getScheduler().schedule(() -> future.complete(new NamedItem(this.name, (Object)false)), this.duration, this.timeUnit);
            ((CompletableFuture)future.thenAcceptAsync(result -> {
                message.removeAllReactions();
                message.edit((this.field != null ? ((Embed.Builder)this.embedBaseSupplier.get()).addField(this.field).addField("Answer:", (Boolean)result.getItem() != false ? "Yes" : "No") : ((Embed.Builder)this.embedBaseSupplier.get()).addField("Answer:", (Boolean)result.getItem() != false ? "Yes" : "No")).build());
                message.detachAllListeners();
            })).exceptionally(Logger::handle);
            if (this.deleteLater) {
                ((CompletableFuture)future.thenRunAsync(() -> this.affiliateMessages.forEach(Message::delete))).exceptionally(Logger::handle);
            }
        });
        return future;
    }

    public YesNo setQuestion(String title, String text) {
        this.field = EmbedDraft.Field.BUILD((String)title, (String)text, (boolean)false);
        return this;
    }
}

