/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui.response;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionAddEvent;
import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionRemoveEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionRemoveListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.server.emoji.UnicodeEmoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.ui.response.ResponseElement;
import de.kaleidox.util.markers.NamedItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Vote<ResultType>
extends ResponseElement<ResultType> {
    private final ArrayList<Option> optionsOrdered = new ArrayList();
    private final HashMap<Option, Integer> rankingMap = new HashMap();

    public Vote(String name, MessageReciever parent, Supplier<Embed.Builder> embedBaseSupplier, Predicate<User> userCanRespond) {
        super(name, parent, embedBaseSupplier, userCanRespond);
    }

    @Override
    public CompletableFuture<NamedItem<ResultType>> build() {
        if (this.optionsOrdered.isEmpty()) {
            throw new NullPointerException("No options registered!");
        }
        Embed.Builder embed = (Embed.Builder)this.embedBaseSupplier.get();
        embed.setDescription("Voting will continue for " + this.duration + " " + this.timeUnit.name().toLowerCase() + ", beginning from the timestamp.").setTimestampNow();
        this.optionsOrdered.forEach(option -> embed.addField(option.getEmoji() + " -> " + option.getName(), option.getDescription()));
        CompletableFuture<NamedItem<ResultType>> future = new CompletableFuture<NamedItem<ResultType>>();
        ((CompletableFuture)this.parent.sendMessage(embed.build()).thenAcceptAsync(message -> {
            this.affiliateMessages.add(message);
            this.optionsOrdered.forEach(option -> message.addReaction(option.getEmoji()));
            message.attachListener((Listener)((ReactionAddListener)this::reactionAdd));
            message.attachListener((Listener)((ReactionRemoveListener)this::reactionRemove));
            this.parent.getDiscord().getThreadPool().getScheduler().schedule(() -> {
                Optional<Object> representationOptional = this.rankingMap.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).map(Option::getValue);
                if (representationOptional.isPresent()) {
                    future.complete(new NamedItem(this.name, representationOptional.get()));
                } else {
                    future.cancel(true);
                }
                message.removeAllReactions();
                Embed.Builder resultEmbed = (Embed.Builder)this.embedBaseSupplier.get();
                message.edit(this.populateResultEmbed(resultEmbed).build());
                message.detachAllListeners();
            }, this.duration, this.timeUnit);
            if (this.deleteLater) {
                ((CompletableFuture)future.thenRunAsync(() -> this.affiliateMessages.forEach(Message::delete))).exceptionally(Logger::handle);
            }
        })).exceptionally(Logger::handle);
        return future;
    }

    private Embed.Builder populateResultEmbed(Embed.Builder embed) {
        this.rankingMap.entrySet().stream().sorted(Comparator.comparingInt(optionIntegerEntry -> (Integer)optionIntegerEntry.getValue() * -1)).forEachOrdered(entry -> {
            Option option = (Option)entry.getKey();
            embed.setDescription("Results are:");
            embed.addField(option.getEmoji() + " -> " + entry.getValue() + " Votes:", "**" + option.getName() + ":**\n" + option.getDescription());
        });
        return embed;
    }

    public Vote<ResultType> addOption(String emoji, String description, ResultType representation) {
        try {
            if (representation.getClass() == Enum.class || representation.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == representation.getClass()) {
                return this.addOption(emoji, representation.toString(), description, representation);
            }
            throw new RuntimeException("The Representation [" + representation + "] has to manually override the method \"toString()\"; or you have to use the implementation of \"addOption(String, String, String, ResultType)\".");
        }
        catch (NoSuchMethodException ignored) {
            throw new AssertionError((Object)"Fatal internal error.");
        }
    }

    public Vote<ResultType> addOption(String emoji, String name, String description, ResultType representation) {
        return this.addOption(new Option((Emoji)UnicodeEmoji.of((Discord)this.parent.getDiscord(), (String)emoji), name, description, representation));
    }

    public Vote<ResultType> addOption(Option option) {
        if (this.optionsOrdered.stream().anyMatch(optionS -> optionS.getEmoji().equals((Object)option.getEmoji()))) {
            throw new ArrayStoreException("Option Emojis can not duplicate!");
        }
        if (this.optionsOrdered.size() == 25) {
            throw new RuntimeException("Only 25 options are allowed.");
        }
        this.optionsOrdered.add(option);
        this.rankingMap.put(option, 0);
        return this;
    }

    private void reactionAdd(ReactionAddEvent event) {
        this.affiliateMessages.add(event.getMessage());
        User user = event.getUser();
        Emoji emoji = event.getEmoji();
        if (!user.isYourself()) {
            if (this.userCanRespond.test(user)) {
                this.optionsOrdered.stream().filter(option -> emoji.equals((Object)option.getEmoji())).findAny().ifPresent(option -> this.rankingMap.put((Option)option, this.rankingMap.getOrDefault(option, 0) + 1));
            } else {
                event.getMessage().removeReactionsByEmoji(new Emoji[]{emoji});
            }
        }
    }

    private void reactionRemove(ReactionRemoveEvent event) {
        this.affiliateMessages.add(event.getMessage());
        User user = event.getUser();
        Emoji emoji = event.getEmoji();
        if (!user.isYourself()) {
            if (this.userCanRespond.test(user)) {
                this.optionsOrdered.stream().filter(option -> emoji.equals((Object)option.getEmoji())).findAny().ifPresent(option -> this.rankingMap.put((Option)option, this.rankingMap.getOrDefault(option, 1) - 1));
            } else {
                event.getMessage().removeReactionsByEmoji(new Emoji[]{emoji});
            }
        }
    }

    public class Option {
        private final Emoji emoji;
        private final String description;
        private final ResultType value;
        private final String name;

        public Option(Emoji emoji, String name, String description, ResultType value) {
            this.emoji = emoji;
            this.name = name;
            this.description = description;
            this.value = value;
        }

        public String toString() {
            return "[" + this.emoji + "|" + this.name + "] with description [" + this.description + "]";
        }

        public Emoji getEmoji() {
            return this.emoji;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ResultType getValue() {
            return this.value;
        }
    }
}

