/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui.response;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.ui.response.ResponseElement;
import de.kaleidox.util.markers.NamedItem;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TextInput
extends ResponseElement<String> {
    private Style style = Style.FULL;
    private EmbedDraft.Field field;

    public TextInput(String name, MessageReciever parent, Supplier<Embed.Builder> embedBaseSupplier, Predicate<User> userCanRespond) {
        super(name, parent, embedBaseSupplier, userCanRespond);
    }

    @Override
    public CompletableFuture<NamedItem<String>> build() {
        CompletableFuture<NamedItem<String>> future = new CompletableFuture<NamedItem<String>>();
        Embed.Builder embed = (Embed.Builder)this.embedBaseSupplier.get();
        embed.setDescription("Please type in your response:").setTimestampNow();
        if (this.field != null) {
            embed.addField(this.field);
        }
        this.parent.sendMessage(embed.build()).thenAcceptAsync(message -> {
            this.affiliateMessages.add(message);
            message.getChannel().attachMessageCreateListener(event -> {
                this.affiliateMessages.add(event.getMessage());
                Message msg = event.getMessage();
                User user = (User)msg.getAuthorAsUser().get();
                if (!user.isYourself() && this.userCanRespond.test(user)) {
                    future.complete(new NamedItem(this.name, (Object)(this.style == Style.READABLE ? msg.getReadableContent() : msg.getContent())));
                }
            });
            ((CompletableFuture)future.thenAcceptAsync(result -> {
                if (result != null) {
                    message.edit((this.field != null ? ((Embed.Builder)this.embedBaseSupplier.get()).addField(this.field).addField("Answer:", (String)result.getItem()) : ((Embed.Builder)this.embedBaseSupplier.get()).addField("Answer:", (String)result.getItem())).build());
                } else {
                    message.edit(((Embed.Builder)this.embedBaseSupplier.get()).addField(this.field).addField("Nobody typed anything.", "There was no valid answer.").build());
                }
            })).exceptionally(Logger::handle);
            this.parent.getDiscord().getThreadPool().getScheduler().schedule(() -> future.complete(null), this.duration, this.timeUnit);
            if (this.deleteLater) {
                ((CompletableFuture)future.thenRunAsync(() -> this.affiliateMessages.forEach(Message::delete))).exceptionally(Logger::handle);
            }
        });
        return future;
    }

    public TextInput setQuestion(String title, String text) {
        this.field = EmbedDraft.Field.BUILD((String)title, (String)text, (boolean)false);
        return this;
    }

    public TextInput setStyle(Style style) {
        this.style = style;
        return this;
    }

    public static enum Style {
        READABLE,
        FULL;

    }
}

