/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui.response;

import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.ui.DialogueBranch;
import de.kaleidox.util.markers.NamedItem;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ResponseElement<ResultType> {
    protected final String name;
    protected final MessageReciever parent;
    protected final Supplier<Embed.Builder> embedBaseSupplier;
    protected final Predicate<User> userCanRespond;
    protected final ArrayList<Message> affiliateMessages;
    protected long duration = 5L;
    protected TimeUnit timeUnit = TimeUnit.MINUTES;
    protected boolean deleteLater = false;
    private DialogueBranch parentBranch;

    public ResponseElement(String name, MessageReciever parent, Supplier<Embed.Builder> embedBaseSupplier, Predicate<User> userCanRespond) {
        this.name = name;
        this.parent = parent;
        this.embedBaseSupplier = embedBaseSupplier == null ? () -> parent.getDiscord().getUtilities().getDefaultEmbed().getBuilder() : embedBaseSupplier;
        this.userCanRespond = userCanRespond == null ? user -> true : userCanRespond;
        this.affiliateMessages = new ArrayList();
    }

    public ResponseElement<ResultType> setParentBranch(DialogueBranch parentBranch) {
        this.parentBranch = parentBranch;
        return this;
    }

    public ResponseElement<ResultType> deleteLater() {
        return this.deleteLater(!this.deleteLater);
    }

    public ResponseElement<ResultType> deleteLater(boolean bool) {
        this.deleteLater = bool;
        return this;
    }

    public CompletableFuture<ResultType> build(long duration, TimeUnit timeUnit) {
        this.setTimeout(duration, timeUnit);
        return CompletableFuture.supplyAsync(() -> this.build().join().getItem());
    }

    public abstract CompletableFuture<NamedItem<ResultType>> build();

    public ResponseElement<ResultType> setTimeout(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public static Predicate<User> sameUserPredicate(User user) {
        return usr -> usr.equals((DiscordItem)user);
    }
}

