/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui.response;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.server.emoji.UnicodeEmoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.ui.response.ResponseElement;
import de.kaleidox.util.markers.NamedItem;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Question<ResultType>
extends ResponseElement<ResultType> {
    private final ArrayList<Option> optionsOrdered = new ArrayList();

    public Question(String name, MessageReciever parent, Supplier<Embed.Builder> embedBaseSupplier, Predicate<User> userCanRespond) {
        super(name, parent, embedBaseSupplier, userCanRespond);
    }

    @Override
    public CompletableFuture<NamedItem<ResultType>> build() {
        if (this.optionsOrdered.isEmpty()) {
            throw new NullPointerException("No options registered!");
        }
        Embed.Builder embed = (Embed.Builder)this.embedBaseSupplier.get();
        embed.setDescription("Voting will continue for " + this.duration + " " + this.timeUnit.name().toLowerCase() + ", beginning from the timestamp.").setTimestampNow();
        this.optionsOrdered.forEach(option -> embed.addField(option.getEmoji() + " -> " + option.getName(), option.getDescription()));
        CompletableFuture<NamedItem<ResultType>> future = new CompletableFuture<NamedItem<ResultType>>();
        ((CompletableFuture)this.parent.sendMessage(embed.build()).thenAcceptAsync(message -> {
            this.affiliateMessages.add(message);
            this.optionsOrdered.forEach(option -> message.addReaction(option.getEmoji()));
            message.attachListener((Listener)((ReactionAddListener)event -> {
                this.affiliateMessages.add(event.getMessage());
                Emoji emoji = event.getEmoji();
                User user = event.getUser();
                if (!user.isYourself() && this.userCanRespond.test(user)) {
                    Optional<Option> any = this.optionsOrdered.stream().filter(option -> ((Option)option).emoji.equals((Object)emoji)).findAny();
                    if (any.isPresent()) {
                        future.complete(new NamedItem(this.name, any.get().getValue()));
                    } else {
                        future.cancel(true);
                    }
                }
            }));
            this.parent.getDiscord().getThreadPool().getScheduler().schedule(() -> {
                message.removeAllReactions();
                message.detachAllListeners();
            }, this.duration, this.timeUnit);
            if (this.deleteLater) {
                ((CompletableFuture)future.thenRunAsync(() -> this.affiliateMessages.forEach(Message::delete))).exceptionally(Logger::handle);
            }
        })).exceptionally(Logger::handle);
        return future;
    }

    public Question<ResultType> addOption(String emoji, String description, ResultType representation) {
        try {
            if (representation.getClass() == Enum.class || representation.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == representation.getClass()) {
                return this.addOption(emoji, representation.toString(), description, representation);
            }
            throw new RuntimeException("The Representation [" + representation + "] has to manually override the method \"toString()\"; or you have to use the implementation of \"addOption(String, String, String, ResultType)\".");
        }
        catch (NoSuchMethodException ignored) {
            throw new AssertionError((Object)"Fatal internal error.");
        }
    }

    public Question<ResultType> addOption(String emoji, String name, String description, ResultType representation) {
        return this.addOption(new Option((Emoji)UnicodeEmoji.of((Discord)this.parent.getDiscord(), (String)emoji), name, description, representation));
    }

    public Question<ResultType> addOption(Option option) {
        if (this.optionsOrdered.stream().anyMatch(optionS -> optionS.getEmoji().equals((Object)option.emoji))) {
            throw new ArrayStoreException("Option Emojis can not duplicate!");
        }
        if (this.optionsOrdered.size() == 25) {
            throw new RuntimeException("Only 25 optionsOrdered are allowed.");
        }
        this.optionsOrdered.add(option);
        return this;
    }

    public class Option {
        private final Emoji emoji;
        private final String description;
        private final ResultType value;
        private final String name;

        public Option(Emoji emoji, String name, String description, ResultType value) {
            this.emoji = emoji;
            this.name = name;
            this.description = description;
            this.value = value;
        }

        public String toString() {
            return "[" + this.emoji + "|" + this.name + "] with description [" + this.description + "]";
        }

        public Emoji getEmoji() {
            return this.emoji;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ResultType getValue() {
            return this.value;
        }
    }
}

