/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.ui;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.util.ui.Dialogue;
import de.kaleidox.crystalshard.util.ui.DialogueEndpoint;
import de.kaleidox.crystalshard.util.ui.DialoguePassthrough;
import de.kaleidox.crystalshard.util.ui.response.ResponseElement;
import de.kaleidox.util.markers.NamedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class DialogueBranch<A>
extends Dialogue {
    private final Dialogue previousBranch;
    final ResponseElement<A> questionElement;
    final ArrayList<Option> options;

    public DialogueBranch(ResponseElement<A> questionElement) {
        this(null, questionElement);
    }

    public DialogueBranch(Dialogue previousBranch, ResponseElement<A> questionElement) {
        this.previousBranch = previousBranch;
        this.questionElement = questionElement;
        this.options = new ArrayList();
    }

    public <B> DialogueBranch<A> addOption(Predicate<A> tester, DialogueBranch<B> followingBranch) {
        return this.addOption(new Option<B>(tester, this, followingBranch));
    }

    public <B> DialogueBranch<A> addOption(Option<B> option) {
        this.options.add(option);
        return this;
    }

    protected void start(List<NamedItem> collectedItems) throws NullPointerException {
        ((CompletableFuture)this.questionElement.setParentBranch(this).build().thenAcceptAsync(response -> this.options.stream().filter(option -> ((Option)option).tester.test(response.getItem())).map(Option::getGoToBranch).forEachOrdered(branch -> {
            collectedItems.add((NamedItem)response);
            if (branch.getClass() == DialogueEndpoint.class) {
                branch.runEndpoint(collectedItems);
            } else if (branch.getClass() == DialoguePassthrough.class) {
                branch.runPassthrough(collectedItems);
                branch.start(new ArrayList<NamedItem>());
            } else {
                branch.start(collectedItems);
            }
        }))).exceptionally(Logger::handle);
    }

    protected CompletableFuture<Void> runEndpoint(List<NamedItem> collectedItems) {
        throw new AbstractMethodError("Abstract method; used by DialogueEndpoint.");
    }

    protected CompletableFuture<Void> runPassthrough(List<NamedItem> collectedItems) {
        throw new AbstractMethodError("Abstract method; used by DialoguePassthrough.");
    }

    public class Option<B> {
        private final Predicate<A> tester;
        private final DialogueBranch<A> parentBranch;
        private final DialogueBranch<B> goToBranch;

        public Option(Predicate<A> tester, DialogueBranch<A> parentBranch, DialogueBranch<B> goToBranch) {
            this.tester = tester;
            this.parentBranch = parentBranch;
            this.goToBranch = goToBranch;
        }

        public Predicate<A> getTester() {
            return this.tester;
        }

        public DialogueBranch<A> getParentBranch() {
            return this.parentBranch;
        }

        public DialogueBranch<B> getGoToBranch() {
            return this.goToBranch;
        }
    }
}

