/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.messages;

import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionRemoveListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class RefreshableMessage {
    private static final ConcurrentHashMap<MessageReciever, RefreshableMessage> selfMap = new ConcurrentHashMap();
    private static final String REFRESH_EMOJI = "\ud83d\udd04";
    private MessageReciever parent;
    private Supplier<EmbedDraft> refresher;
    private Message lastMessage = null;

    private RefreshableMessage(MessageReciever inParent, Supplier<EmbedDraft> refresher) {
        this.parent = inParent;
        this.refresher = refresher;
        EmbedDraft item = refresher.get();
        CompletableFuture sent = this.parent.sendMessage(refresher.get());
        if (sent != null) {
            sent.thenAcceptAsync(msg -> {
                this.lastMessage = msg;
                msg.attachListener((Listener)((ReactionAddListener)this::onRefresh));
                msg.attachListener((Listener)((ReactionRemoveListener)this::onRefresh));
                msg.addReaction(REFRESH_EMOJI);
            });
        }
    }

    private void onRefresh(ReactionEvent event) {
        Emoji emoji;
        if (!event.getUser().isYourself() && (emoji = event.getEmoji()).getMentionTag().equals(REFRESH_EMOJI)) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.lastMessage != null) {
            this.lastMessage.edit(this.refresher.get());
        }
    }

    public void resend() {
        CompletableFuture sent = null;
        if (this.lastMessage != null) {
            this.lastMessage.delete("Outdated");
        }
        if (sent != null) {
            sent.thenAcceptAsync(msg -> {
                this.lastMessage = msg;
                msg.attachListener((Listener)((ReactionAddListener)this::onRefresh));
                msg.attachListener((Listener)((ReactionRemoveListener)this::onRefresh));
                msg.addReaction(REFRESH_EMOJI);
            });
        }
    }

    public static RefreshableMessage get(MessageReciever forParent, Supplier<EmbedDraft> defaultRefresher) {
        if (selfMap.containsKey(forParent)) {
            RefreshableMessage val = selfMap.get(forParent);
            val.resend();
            return val;
        }
        return selfMap.put(forParent, new RefreshableMessage(forParent, defaultRefresher));
    }

    public static final Optional<RefreshableMessage> get(MessageReciever forParent) {
        if (selfMap.containsKey(forParent)) {
            RefreshableMessage val = selfMap.get(forParent);
            val.resend();
            return Optional.of(val);
        }
        return Optional.empty();
    }
}

