/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.messages;

import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionRemoveListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class PagedMessage {
    private static final ConcurrentHashMap<MessageReciever, PagedMessage> selfMap = new ConcurrentHashMap();
    private static final String PREV_PAGE_EMOJI = "\u2b05";
    private static final String NEXT_PAGE_EMOJI = "\u27a1";
    private static final int SUITABLE_MAX_LENGTH = 1700;
    private MessageReciever parent;
    private Supplier<String> head;
    private Supplier<String> body;
    private Message lastMessage = null;
    private List<String> pages = new ArrayList<String>();
    private int page;

    private PagedMessage(MessageReciever inParent, Supplier<String> head, Supplier<String> body) {
        this.parent = inParent;
        this.head = head;
        this.body = body;
        this.page = 0;
        this.resend();
    }

    public void resend() {
        this.refreshPages();
        if (this.lastMessage != null) {
            this.lastMessage.delete("Outdated");
        }
        this.parent.sendMessage(this.getPageContent()).thenAcceptAsync(msg -> {
            this.lastMessage = msg;
            msg.attachListener((Listener)((ReactionAddListener)this::onPageClick));
            msg.attachListener((Listener)((ReactionRemoveListener)this::onPageClick));
            msg.addReaction(PREV_PAGE_EMOJI);
            msg.addReaction(NEXT_PAGE_EMOJI);
        });
    }

    private String getPageContent() {
        return this.pages.get(this.page) + "\n\n`Page " + (this.page + 1) + " of " + this.pages.size() + " | Last Refresh: " + new SimpleDateFormat("HH:mm:ss").format(new Timestamp(System.currentTimeMillis())) + " [GMT+2]`";
    }

    private void refreshPages() {
        String completeHead = this.head.get();
        String completeBody = this.body.get();
        String completeMessage = completeHead + completeBody;
        List<String> bodyLines = Arrays.asList(completeBody.split("\n"));
        this.pages.clear();
        if (completeMessage.length() < 1700) {
            this.pages.add(completeMessage);
        } else {
            StringBuilder pageBuilder = new StringBuilder(completeHead);
            for (int i = 0; i < bodyLines.size(); ++i) {
                pageBuilder.append(bodyLines.get(i));
                pageBuilder.append("\n");
                if (i != bodyLines.size() - 1 && pageBuilder.length() + bodyLines.get(i + 1).length() < 1700) continue;
                this.pages.add(pageBuilder.toString());
                pageBuilder = new StringBuilder(completeHead);
            }
        }
    }

    private void onPageClick(ReactionEvent event) {
        if (!event.getUser().isYourself()) {
            Emoji emoji = event.getEmoji();
            switch (emoji.getMentionTag()) {
                case "\u2b05": {
                    if (this.page > 0) {
                        --this.page;
                    }
                    this.refreshPage();
                    break;
                }
                case "\u27a1": {
                    if (this.page < this.pages.size() - 1) {
                        ++this.page;
                    }
                    this.refreshPage();
                }
            }
        }
    }

    public void refreshPage() {
        this.refreshPages();
        if (this.lastMessage != null) {
            this.lastMessage.edit(this.getPageContent());
        }
    }

    public void refresh() {
        this.page = 0;
        this.refreshPage();
    }

    public static final PagedMessage get(MessageReciever forParent, Supplier<String> defaultHead, Supplier<String> defaultBody) {
        if (selfMap.containsKey(forParent)) {
            PagedMessage val = selfMap.get(forParent);
            val.resend();
            return val;
        }
        return selfMap.put(forParent, new PagedMessage(forParent, defaultHead, defaultBody));
    }

    public static final Optional<PagedMessage> get(MessageReciever forParent) {
        if (selfMap.containsKey(forParent)) {
            PagedMessage val = selfMap.get(forParent);
            val.resend();
            return Optional.of(val);
        }
        return Optional.empty();
    }
}

