/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.messages;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.util.helpers.ListHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class InformationMessage {
    private static final ConcurrentHashMap<MessageReciever, InformationMessage> selfMap = new ConcurrentHashMap();
    private MessageReciever messageable;
    private ArrayList<InformationField> fields = new ArrayList();
    private AtomicReference<Message> myMessage = new AtomicReference();

    private InformationMessage(MessageReciever messageable) {
        this.messageable = messageable;
        selfMap.putIfAbsent(messageable, this);
    }

    public InformationMessage addField(String name, String title, String text) {
        return this.addField(name, title, text, false);
    }

    public InformationMessage addField(String name, String title, String text, boolean inline) {
        this.fields.add(new InformationField(name, title, text, inline));
        return this;
    }

    public InformationMessage editField(String name, String newText) {
        return this.editField(name, null, newText, false);
    }

    public InformationMessage editField(String name, String newTitle, String newText, boolean newInline) {
        InformationField field;
        Optional complex = ListHelper.findComplex(this.fields, (Object)name, InformationField::getName);
        if (complex.isPresent()) {
            field = (InformationField)complex.get();
            if (newTitle != null) {
                field.setTitle(newTitle);
            }
        } else {
            throw new NullPointerException("Could not find field: " + name);
        }
        field.setText(newText);
        field.setInline(newInline);
        return this;
    }

    public InformationMessage editField(String name, String newTitle, String newText) {
        return this.editField(name, newTitle, newText, false);
    }

    public InformationMessage removeField(String name) {
        Optional complex = ListHelper.findComplex(this.fields, (Object)name, InformationField::getName);
        if (!complex.isPresent()) {
            throw new NullPointerException("Could not find field: " + name);
        }
        InformationField field = (InformationField)complex.get();
        this.fields.remove(field);
        return this;
    }

    public void refresh() {
        Embed.Builder embed = this.messageable.getDiscord().getUtilities().getDefaultEmbed().getBuilder();
        for (InformationField field : this.fields) {
            embed.addField(field.title, field.text, field.inline);
        }
        if (this.myMessage.get() != null) {
            ((CompletableFuture)this.myMessage.get().delete().thenRunAsync(() -> ((CompletableFuture)this.messageable.sendMessage(embed.build()).thenAcceptAsync(this.myMessage::set)).exceptionally(Logger::handle))).exceptionally(Logger::handle);
        } else {
            ((CompletableFuture)this.messageable.sendMessage(embed.build()).thenAcceptAsync(msg -> this.myMessage.set((Message)msg))).exceptionally(Logger::handle);
        }
    }

    public static final InformationMessage getInstance(MessageReciever messageable) {
        return selfMap.getOrDefault(messageable, new InformationMessage(messageable));
    }

    class InformationField {
        private String name;
        private String title;
        private String text;
        private boolean inline;

        InformationField(String name, String title, String text, boolean inline) {
            this.name = name;
            this.title = title;
            this.text = text;
            this.inline = inline;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean getInline() {
            return this.inline;
        }

        public void setInline(boolean inline) {
            this.inline = inline;
        }
    }
}

