/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.input;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionAddEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.input.Base;
import de.kaleidox.crystalshard.util.input.Choice;
import de.kaleidox.util.CompletableFutureExtended;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SingleChoiceInput<T>
extends Base<T> {
    private List<Choice<T>> choices = new ArrayList<Choice<T>>();

    protected SingleChoiceInput(MessageReciever parent, String name, T defaultValue) {
        super(parent, name, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, T defaultValue) {
        super(parent, embedModifier, name, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, long time, TimeUnit unit, T defaultValue) {
        super(parent, embedModifier, name, time, unit, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, User user, String name, T defaultValue) {
        super(parent, user, name, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, T defaultValue) {
        super(parent, embedModifier, user, name, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, long time, TimeUnit unit, T defaultValue) {
        super(parent, embedModifier, user, name, time, unit, defaultValue);
    }

    protected SingleChoiceInput(MessageReciever parent, Consumer<Embed.Builder> embedModifier, Predicate<User> participantTester, String name, long time, TimeUnit unit, T defaultValue, boolean deleteWhenDone) {
        super(parent, embedModifier, participantTester, name, time, unit, defaultValue, deleteWhenDone);
    }

    public SingleChoiceInput<T> addChoice(String emojiRepresentation, String name, String description, T value) {
        this.choices.add(new Choice<T>(emojiRepresentation, name, description, value));
        return this;
    }

    @Override
    public CompletableFuture<T> build() {
        final CompletableFutureExtended future = this.createFuture();
        Embed.Builder embed = this.createEmbed();
        if (embed.getFields().size() + this.choices.size() > 25) {
            throw new IllegalArgumentException("Too many fields in the embed!");
        }
        for (Choice<T> choice : this.choices) {
            embed.addField(choice.getEmojiRepresentation() + " -> " + choice.getName(), choice.getDescription());
        }
        ((CompletableFuture)this.parent.sendMessage(embed.build()).exceptionally(arg_0 -> ((Logger)logger).exception(arg_0))).thenAcceptAsync(message -> {
            this.addAffiliate((Message)message);
            for (Choice<T> choice : this.choices) {
                message.addReaction(choice.getEmojiRepresentation());
            }
            message.attachListener((Listener)new ReactionAddListener((Message)message){
                final /* synthetic */ Message val$message;
                {
                    this.val$message = message;
                }

                public void onReactionAdd(ReactionAddEvent event) {
                    if (!event.getUser().isYourself() && SingleChoiceInput.this.participantTester.test(event.getUser()) && SingleChoiceInput.this.choices.stream().map(Choice::getEmojiRepresentation).collect(Collectors.toSet()).contains(event.getEmoji().toDiscordPrintable())) {
                        Optional<Choice> any = SingleChoiceInput.this.choices.stream().filter(choice -> choice.getEmojiRepresentation().equals(event.getEmoji().toDiscordPrintable())).findAny();
                        if (!any.isPresent()) {
                            event.getReaction().remove();
                            assert (false) : "This point should never be reached.";
                        }
                        any.ifPresent(choice -> {
                            future.complete(choice.getValue());
                            this.val$message.detachListener((Listener)this);
                            SingleChoiceInput.this.cleanup();
                        });
                    } else {
                        event.getReaction().remove();
                    }
                }
            }).detachIn(this.time, this.unit).onDetach(() -> {
                if (!future.isDone()) {
                    future.complete(this.defaultValue);
                }
            });
        });
        return future;
    }
}

