/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.input;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.handling.event.message.generic.MessageCreateEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.generic.MessageCreateListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.input.Base;
import de.kaleidox.crystalshard.util.util.InfoReaction;
import de.kaleidox.util.CompletableFutureExtended;
import de.kaleidox.util.helpers.StringHelper;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class NumberInput
extends Base<Long> {
    private final long min;
    private final long max;

    protected NumberInput(long min, long max, MessageReciever parent, String name, Long defaultValue) {
        super(parent, name, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, Long defaultValue) {
        super(parent, embedModifier, name, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, long time, TimeUnit unit, Long defaultValue) {
        super(parent, embedModifier, name, time, unit, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, User user, String name, Long defaultValue) {
        super(parent, user, name, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, Long defaultValue) {
        super(parent, embedModifier, user, name, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, long time, TimeUnit unit, Long defaultValue) {
        super(parent, embedModifier, user, name, time, unit, defaultValue);
        this.min = min;
        this.max = max;
    }

    protected NumberInput(long min, long max, MessageReciever parent, Consumer<Embed.Builder> embedModifier, Predicate<User> participantTester, String name, long time, TimeUnit unit, Long defaultValue, boolean deleteWhenDone) {
        super(parent, embedModifier, participantTester, name, time, unit, defaultValue, deleteWhenDone);
        this.min = min;
        this.max = max;
    }

    public CompletableFuture<Integer> buildInteger() {
        return this.build().thenApply(lng -> {
            if (lng <= Integer.MAX_VALUE && lng >= Integer.MIN_VALUE) {
                return lng.intValue();
            }
            throw new IndexOutOfBoundsException("The value is too " + (lng > Integer.MAX_VALUE ? "large" : "small") + "!");
        });
    }

    @Override
    public CompletableFuture<Long> build() {
        CompletableFutureExtended future = this.createFuture();
        Embed.Builder embed = this.createEmbed();
        ((CompletableFuture)this.parent.sendMessage(embed.build()).exceptionally(arg_0 -> ((Logger)logger).exception(arg_0))).thenAcceptAsync(message -> {
            this.addAffiliate((Message)message);
            message.getChannel().attachListener((Listener)new MessageCreateListener((CompletableFuture)future, (Message)message){
                final /* synthetic */ CompletableFuture val$future;
                final /* synthetic */ Message val$message;
                {
                    this.val$future = completableFuture;
                    this.val$message = message;
                }

                public void onMessageCreate(MessageCreateEvent event) {
                    event.getMessageAuthorUser().filter(NumberInput.this.participantTester::test).filter(usr -> !usr.isYourself()).ifPresent(author -> {
                        if (StringHelper.isNumeric((String)event.getMessageContent())) {
                            long val = Long.valueOf(event.getMessageContent());
                            if (val >= NumberInput.this.min && val <= NumberInput.this.max) {
                                this.val$future.complete(val);
                                this.val$message.getChannel().detachListener((Listener)this).onFailure(bFalse -> Base.logger.error((Object)("Error detaching listener: " + this)));
                                NumberInput.this.cleanup();
                            } else {
                                Embed.Builder builder = Embed.BUILDER();
                                builder.setColor(Color.RED).setTitle("Error").addField("Error with the number!", "The given number ```" + val + "``` is too " + (val < NumberInput.this.min ? "small" : "big") + "!\n\nIt must be at least `" + NumberInput.this.min + "` and at last `" + NumberInput.this.max + "`!");
                                InfoReaction.add(event.getMessage(), builder);
                            }
                        }
                    });
                }
            }).detachIn(this.time, this.unit).onDetach(() -> {
                if (!future.isDone()) {
                    future.complete((Long)this.defaultValue);
                }
            });
        });
        return future;
    }
}

