/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.input;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.CompletableFutureExtended;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Base<T> {
    protected static final Logger logger = new Logger(Base.class);
    protected final boolean deleteWhenDone;
    protected final String name;
    protected final long time;
    protected final TimeUnit unit;
    protected final T defaultValue;
    protected final MessageReciever parent;
    protected final Predicate<User> participantTester;
    private final Consumer<Embed.Builder> embedModifier;
    private final List<Message> affiliates;
    protected Function<T, String> toStringFunction = Object::toString;
    private User constructedForSpecified = null;

    protected Base(MessageReciever parent, String name, T defaultValue) {
        this(parent, (Embed.Builder builder) -> builder.addField(name.toUpperCase(), "Please enter a value for ```" + name + "```:"), name, defaultValue);
    }

    protected Base(MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, T defaultValue) {
        this(parent, embedModifier, name, 5L, TimeUnit.MINUTES, defaultValue);
    }

    protected Base(MessageReciever parent, Consumer<Embed.Builder> embedModifier, String name, long time, TimeUnit unit, T defaultValue) {
        this(parent, embedModifier, usr -> true, name, time, unit, defaultValue, true);
    }

    protected Base(MessageReciever parent, Consumer<Embed.Builder> embedModifier, Predicate<User> participantTester, String name, long time, TimeUnit unit, T defaultValue, boolean deleteWhenDone) {
        this.parent = Objects.requireNonNull(parent);
        this.embedModifier = Objects.requireNonNull(embedModifier);
        this.participantTester = Objects.requireNonNull(participantTester);
        this.name = Objects.requireNonNull(name);
        this.time = time;
        this.unit = Objects.requireNonNull(unit);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.deleteWhenDone = deleteWhenDone;
        this.affiliates = new ArrayList<Message>();
    }

    protected Base(MessageReciever parent, User user, String name, T defaultValue) {
        this(parent, builder -> builder.addField(name.toUpperCase(), "Please enter a value for ```" + name + "```:"), user, name, defaultValue);
    }

    protected Base(MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, T defaultValue) {
        this(parent, embedModifier, user, name, 5L, TimeUnit.MINUTES, defaultValue);
    }

    protected Base(MessageReciever parent, Consumer<Embed.Builder> embedModifier, User user, String name, long time, TimeUnit unit, T defaultValue) {
        this(parent, embedModifier, arg_0 -> ((User)user).equals(arg_0), name, time, unit, defaultValue, true);
        this.constructedForSpecified = user;
    }

    public abstract CompletableFuture<T> build();

    protected void cleanup() {
        if (this.deleteWhenDone) {
            this.affiliates.forEach(Message::delete);
        }
    }

    protected void addAffiliate(Message message) {
        this.affiliates.add(message);
    }

    protected CompletableFutureExtended<T> createFuture() {
        return new CompletableFutureExtended(this.parent.getDiscord().getExecutor());
    }

    protected Embed.Builder createEmbed() {
        Embed.Builder builder = Embed.BUILDER();
        builder.setTimestampNow();
        builder.setFooter("If you dont respond within " + this.time + " " + this.unit.name().toLowerCase() + ", the automatic response will be `" + this.toStringFunction.apply(this.defaultValue) + "`!");
        if (this.parent instanceof ServerChannel) {
            Server server = ((ServerChannel)this.parent).getServer();
            ServerMember member = (ServerMember)server.getDiscord().getSelf().toServerMember(server).orElseThrow(AssertionError::new);
            member.getRoleColor().ifPresent(arg_0 -> ((Embed.Builder)builder).setColor(arg_0));
        }
        if (this.constructedForSpecified != null) {
            builder.setAuthor("Only " + this.constructedForSpecified.getDiscriminatedName() + " can respond to this!", this.constructedForSpecified.getAvatarUrl().map(URL::toExternalForm).orElse("http://google.com"), this.constructedForSpecified.getAvatarUrl().map(URL::toExternalForm).orElse("http://google.com"));
        }
        this.embedModifier.accept(builder);
        return builder;
    }

    public void setToStringFunction(Function<T, String> toStringFunction) {
        this.toStringFunction = toStringFunction;
    }
}

