/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.embeds;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.crystalshard.internal.InternalInjector;
import de.kaleidox.crystalshard.internal.items.message.embed.EmbedBuilderInternal;
import de.kaleidox.crystalshard.internal.items.message.embed.EmbedDraftInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.event.message.reaction.ReactionEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionRemoveListener;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.util.helpers.JsonHelper;
import java.awt.Color;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class PagedEmbed
extends EmbedBuilderInternal
implements Embed.Builder {
    public static final long KEEPALIVE_TIME = 4L;
    public static final TimeUnit KEEPALIVE_UNIT = TimeUnit.HOURS;
    public static final int MAX_CHARS_PER_PAGE = 4500;
    public static final int MAX_FIELDS_PER_PAGE = 8;
    public static final int MAX_INSTANCES_PER_CHANNEL = 2;
    public static final String PREV_PAGE_EMOJI = "\u2b05";
    public static final String NEXT_PAGE_EMOJI = "\u27a1";
    public static final String DELETE_EMOJI = "\ud83d\uddd1";
    private static final List<Built> built = new ArrayList<Built>();
    private final Discord discord;
    private final AtomicReference<Message> sentMessage;
    private Built myBuilt;
    private Hashtable<Integer, List<EmbedDraft.Field>> pages;
    private int page;

    private PagedEmbed(Discord discord) {
        this.discord = discord;
        this.ignoreFieldCount = true;
        this.page = 0;
        this.pages = new Hashtable();
        this.sentMessage = new AtomicReference();
    }

    public Embed.Builder addField(EmbedDraft.Field field) {
        super.addField(field);
        return this;
    }

    public EmbedDraft build() {
        this.partitionFields();
        this.myBuilt = new Built(this, this.title, this.description, this.url, this.timestamp, this.color, this.footer, this.image, this.thumbnail, this.author, new ArrayList<EmbedDraft.Field>());
        this.discord.getTunnelFramework().subscribe((Object)this.myBuilt, Message.class, this::tunnelHandler);
        return this.myBuilt;
    }

    public Embed.Builder setFooter(EmbedDraft.Footer footer) {
        throw new AbstractMethodError("In the paged embed, the footer is used for telling what page you are on! [CANNOT SET FOOTER]");
    }

    public Embed.Builder addField(String title, String text, boolean inline) {
        EmbedDraft.Field field = (EmbedDraft.Field)InternalInjector.newInstance(EmbedDraft.Field.class, (Object[])new Object[]{title, text, inline});
        this.addField(field);
        return this;
    }

    public Embed.Builder addField(String title, String text) {
        this.addField(title, text, false);
        return this;
    }

    private void tunnelHandler(Message message) {
        this.sentMessage.set(message);
        message.addReaction(new String[]{PREV_PAGE_EMOJI, NEXT_PAGE_EMOJI, DELETE_EMOJI});
        message.attachListener((Listener)((ReactionAddListener)this::onReactionClick));
        message.attachListener((Listener)((ReactionRemoveListener)this::onReactionClick));
        message.getDiscord().getScheduler().schedule(() -> this.sentMessage.get().delete("Keepalive-Time ran out!"), 4L, KEEPALIVE_UNIT);
    }

    private void onReactionClick(ReactionEvent event) {
        if (!event.getUser().isYourself()) {
            switch (event.getEmoji().toDiscordPrintable()) {
                case "\u2b05": {
                    --this.page;
                    if (this.page < 0) {
                        this.page = this.pages.size() - 1;
                    }
                    this.sentMessage.get().edit((EmbedDraft)this.myBuilt);
                    break;
                }
                case "\u27a1": {
                    ++this.page;
                    if (this.page >= this.pages.size()) {
                        this.page = 0;
                    }
                    this.sentMessage.get().edit((EmbedDraft)this.myBuilt);
                    break;
                }
                case "\ud83d\uddd1": {
                    this.sentMessage.get().delete("Delete-Emoji clicked!");
                    break;
                }
                default: {
                    event.getMessage().removeReactionsByEmoji(new Emoji[]{event.getEmoji()});
                }
            }
        }
    }

    private void partitionFields() {
        Hashtable tempPages = new Hashtable();
        int page = 0;
        for (EmbedDraft.Field field : this.fields) {
            tempPages.putIfAbsent(page, new ArrayList());
            if (((List)tempPages.get(page)).stream().mapToInt(EmbedDraft.Field::getTotalCharCount).sum() + field.getTotalCharCount() >= 4500 || ((List)tempPages.get(page)).size() >= 8) {
                ++page;
            }
            tempPages.putIfAbsent(page, new ArrayList());
            ((List)tempPages.get(page)).add(field);
        }
        this.pages.putAll(tempPages);
    }

    public static Embed.Builder builder(Discord discord) {
        return new PagedEmbed(discord);
    }

    private class Built
    extends EmbedDraftInternal {
        private final PagedEmbed root;

        public Built(PagedEmbed root, String title, String description, URL url, Instant timestamp, Color color, EmbedDraft.Footer footer, EmbedDraft.Image image, EmbedDraft.Thumbnail thumbnail, EmbedDraft.Author author, ArrayList<EmbedDraft.Field> fields) {
            super(title, description, url, timestamp, color, footer, image, thumbnail, author, fields);
            this.root = root;
            built.add(this);
        }

        public ObjectNode toJsonNode(ObjectNode object) {
            ObjectNode obj = super.toJsonNode(object);
            obj.remove("fields");
            if (PagedEmbed.this.fields.size() > 0) {
                ArrayNode jsonFields = obj.putArray("fields");
                for (EmbedDraft.Field field : (List)PagedEmbed.this.pages.get(PagedEmbed.this.page)) {
                    ObjectNode jsonField = jsonFields.addObject();
                    jsonField.set("name", JsonHelper.nodeOf((Object)field.getTitle()));
                    jsonField.set("value", JsonHelper.nodeOf((Object)field.getText()));
                    jsonField.set("inline", JsonHelper.nodeOf((Object)field.isInline()));
                }
            }
            return obj;
        }
    }
}

