/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.command;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.event.message.generic.MessageCreateEvent;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.generic.MessageCreateListener;
import de.kaleidox.crystalshard.main.items.channel.PrivateTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.channel.TextChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.Author;
import de.kaleidox.crystalshard.main.items.user.Self;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.command.Command;
import de.kaleidox.crystalshard.util.command.CommandFramework;
import de.kaleidox.crystalshard.util.embeds.PagedEmbed;
import de.kaleidox.util.functional.Switch;
import de.kaleidox.util.helpers.ListHelper;
import de.kaleidox.util.helpers.SetHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class CommandFrameworkImpl
implements CommandFramework {
    private static final Logger logger = new Logger(CommandFrameworkImpl.class);
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final Discord discord;
    private final String prefix;
    private final List<Instance> commands;
    private final List<TextChannel> ignored;

    public CommandFrameworkImpl(Discord discord, String prefix, boolean enableBuiltInHelpCommand) {
        this.discord = discord;
        this.prefix = prefix;
        this.commands = new ArrayList<Instance>();
        this.ignored = new ArrayList<TextChannel>();
        this.enabled.set(true);
        if (!enableBuiltInHelpCommand) {
            Method helpMethod = null;
            for (Method method : CommandFrameworkImpl.class.getMethods()) {
                if (!method.getName().equals("defaultHelp")) continue;
                helpMethod = method;
                break;
            }
            assert (helpMethod != null);
            this.unregisterCommand(helpMethod);
        }
        this.commandRegistry();
        discord.attachListener((Listener)((MessageCreateListener)this::handle));
    }

    private void commandRegistry() {
        Package[] packages = ClassLoader.getSystemClassLoader().getDefinedPackages();
        String[] packageNames = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            packageNames[i] = packages[i].getName();
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addScanners(new Scanner[]{new MethodAnnotationsScanner()}).forPackages(packageNames));
        reflections.getMethodsAnnotatedWith(Command.class).forEach(this::registerCommands);
    }

    public void registerCommands(Class commandClass) throws IllegalArgumentException, IllegalStateException {
        Stream.of(commandClass.getMethods()).filter(method -> method.isAnnotationPresent(Command.class)).forEach(this::registerCommandMethod);
    }

    public List<Command> getCommands() {
        return this.commands.stream().map(inst -> ((Instance)inst).annotation).collect(Collectors.toList());
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    public void ignore(TextChannel object) {
        this.ignored.add(object);
    }

    public boolean unignore(TextChannel object) {
        return this.ignored.stream().filter(arg_0 -> ((TextChannel)object).equals(arg_0)).findAny().map(this.ignored::remove).orElse(false);
    }

    public void registerCommands(Method commandMethod) throws IllegalArgumentException, IllegalStateException {
        this.registerCommandMethod(commandMethod);
    }

    public boolean unregisterCommand(Method commandMethod) {
        return this.commands.stream().filter(instance -> ((Instance)instance).method == commandMethod).findAny().map(this.commands::remove).orElse(false);
    }

    private void handle(MessageCreateEvent event) {
        if (this.enabled.get() && !this.ignored.contains(event.getChannel().toTextChannel().orElseThrow(AssertionError::new))) {
            this.commands.stream().filter(instance -> this.checkAlias((Instance)instance, event.getMessageContent())).filter(instance -> this.checkProperties(((Instance)instance).annotation, event)).map(instance -> ((Instance)instance).method).forEach(method -> this.runWithDynamicParams((Method)method, event));
        }
    }

    private void runWithDynamicParams(Method method, MessageCreateEvent event) {
        Command annotation = method.getAnnotation(Command.class);
        Discord discord = event.getDiscord();
        Server server = event.getServer().orElse(null);
        TextChannel channel = (TextChannel)event.getChannel().toTextChannel().orElseThrow(AssertionError::new);
        Message message = event.getMessage();
        Author author = event.getMessageAuthor();
        String content = event.getMessageContent();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] finalParam = new Object[parameterTypes.length];
        int[] ref = new int[1];
        Switch swtc = new Switch(Class::isAssignableFrom).addCase(MessageCreateEvent.class, type -> {
            finalParam[ref[0]] = event;
        }).addCase(Discord.class, type -> {
            finalParam[ref[0]] = discord;
        }).addCase(Server.class, type -> {
            finalParam[ref[0]] = server;
        }).addCase(TextChannel.class, type -> {
            finalParam[ref[0]] = channel;
        }).addCase(Message.class, type -> {
            finalParam[ref[0]] = message;
        }).addCase(Author.class, type -> {
            finalParam[ref[0]] = author;
        }).addCase(String.class, type -> {
            finalParam[ref[0]] = content;
        }).defaultCase(type -> {
            finalParam[ref[0]] = null;
        }).addCase(ServerTextChannel.class, type -> {
            finalParam[ref[0]] = channel.toServerTextChannel().orElse(null);
        }).addCase(PrivateTextChannel.class, type -> {
            finalParam[ref[0]] = channel.toPrivateTextChannel().orElse(null);
        });
        ref[0] = 0;
        while (ref[0] < parameterTypes.length) {
            swtc.test(parameterTypes[ref[0]]);
            ref[0] = ref[0] + 1;
        }
        discord.getThreadPool().execute(() -> {
            try {
                method.invoke((Object)this, finalParam);
            }
            catch (Exception e) {
                logger.exception((Throwable)e, "Exception invoking command Method: " + method.toGenericString());
            }
        }, new String[0]);
    }

    private boolean checkProperties(Command annotation, MessageCreateEvent event) {
        int criteria = 0;
        Permission permission = annotation.requiredDiscordPermission();
        boolean serverChat = annotation.enableServerChat();
        boolean privateChat = annotation.enablePrivateChat();
        int channelMentions = annotation.requireChannelMentions();
        int userMentions = annotation.requireUserMentions();
        int roleMentions = annotation.requireRoleMentions();
        TextChannel channel = (TextChannel)event.getChannel().toTextChannel().orElseThrow(AssertionError::new);
        Optional authorUserOpt = event.getMessageAuthorUser();
        Message message = event.getMessage();
        if (authorUserOpt.isPresent()) {
            if (channel.hasPermission((User)authorUserOpt.get(), permission)) {
                ++criteria;
            }
        } else {
            ++criteria;
        }
        if (serverChat == !channel.isPrivate()) {
            ++criteria;
        } else if (privateChat == channel.isPrivate()) {
            ++criteria;
        }
        if (message.getChannelMentions().size() >= channelMentions) {
            ++criteria;
        }
        if (message.getUserMentions().size() >= userMentions) {
            ++criteria;
        }
        if (message.getRoleMentions().size() >= roleMentions) {
            ++criteria;
        }
        return criteria == 6;
    }

    private boolean checkAlias(Instance instance, String messageContent) {
        if (messageContent.indexOf(this.prefix) == 0) {
            List split = ListHelper.of((Object[])messageContent.split(" "));
            boolean prefixHasSpace = this.prefix.charAt(this.prefix.length() - 1) == ' ';
            for (String alias : instance.annotation.aliases()) {
                Objects.requireNonNull(alias);
                if (!((String)split.get(prefixHasSpace ? 1 : 0)).equalsIgnoreCase((prefixHasSpace ? "" : this.prefix) + alias)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerCommandMethod(Method method) throws IllegalArgumentException, IllegalStateException {
        if (!method.isAnnotationPresent(Command.class)) {
            throw new IllegalArgumentException("Method " + method.toGenericString() + " does not have annotation " + Command.class + ".");
        }
        Command commandAnnot = ((Command[])method.getAnnotationsByType(Command.class))[0];
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException("The command methods must be static.");
        }
        if (!commandAnnot.enableServerChat() && SetHelper.of(HashSet.class, (Object[])method.getParameterTypes()).contains(Server.class)) {
            logger.exception((Throwable)new InvalidParameterException("Command " + method.toGenericString() + " is annotated to not run on Servers, yet expects a Server-Parameter. It will only recieve null."), "Error in Command method body for: " + method.toGenericString());
        }
        if (this.hasAliasesRegistered(commandAnnot.aliases())) {
            logger.exception((Throwable)new IllegalArgumentException("A command with one of the aliases " + Arrays.toString(commandAnnot.aliases()) + " is registered already!"), "Error in Command aliases for: " + method.toGenericString());
        }
        Instance instance = new Instance(method, commandAnnot);
        this.commands.add(instance);
    }

    private boolean hasAliasesRegistered(String[] aliases) {
        return this.commands.stream().flatMap(cmd -> Stream.of(((Instance)cmd).annotation.aliases())).anyMatch(alias -> ListHelper.of((Object[])aliases).contains(alias));
    }

    @Command(aliases={"help"}, description="Shows a list of all commands.")
    public static void defaultHelp(Discord discord, Server server, Author author, TextChannel channel) {
        CommandFrameworkImpl framework = (CommandFrameworkImpl)discord.getUtilities().getCommandFramework();
        Self self = discord.getSelf();
        Embed.Builder builder = PagedEmbed.builder(discord);
        self.getAvatarUrl().map(URL::toExternalForm).ifPresent(arg_0 -> ((Embed.Builder)builder).setThumbnail(arg_0));
        builder.setTitle(self.getDisplayName(server) + " Commands");
        framework.commands.stream().map(inst -> ((Instance)inst).annotation).forEachOrdered(annotation -> {
            if (annotation.shownInDefaultHelp()) {
                StringBuilder sb = new StringBuilder();
                String description = annotation.description();
                sb.append(description).append("\nWorks in:\n").append(annotation.enablePrivateChat() ? "\ud83d\udd12 Private Chat\n" : "").append(annotation.enableServerChat() ? "\ud83c\udf10 Server Chat\n" : "").append(annotation.requiredDiscordPermission() == Permission.EMPTY ? "" : String.format("Required Discord-Permission: %s\n", annotation.requiredDiscordPermission().toString())).append(annotation.requireChannelMentions() == 0 ? "" : String.format("Required Channel-Mentions: %d\n", annotation.requireChannelMentions())).append(annotation.requireUserMentions() == 0 ? "" : String.format("Required User-Mentions: %d\n", annotation.requireUserMentions())).append(annotation.requireRoleMentions() == 0 ? "" : String.format("Required Role mentions: %d\n", annotation.requireRoleMentions()));
                StringBuilder aliases = new StringBuilder(framework.prefix);
                Iterator iterator = ListHelper.of((Object[])annotation.aliases()).iterator();
                while (iterator.hasNext()) {
                    String next = (String)iterator.next();
                    aliases.append(next);
                    if (!iterator.hasNext()) continue;
                    aliases.append(" | ");
                }
                builder.addField(aliases.toString(), sb.toString());
            }
        });
        builder.send((MessageReciever)channel);
    }

    private class Instance {
        private final Method method;
        private final Command annotation;

        private Instance(Method method, Command annotation) {
            this.method = method;
            this.annotation = annotation;
        }
    }
}

