/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.util.DefaultEmbed;
import de.kaleidox.crystalshard.util.DefaultEmbedImpl;
import de.kaleidox.crystalshard.util.DiscordUtils;
import de.kaleidox.crystalshard.util.command.CommandFramework;
import de.kaleidox.crystalshard.util.command.CommandFrameworkImpl;
import de.kaleidox.util.helpers.JsonHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class DiscordUtilsImpl
implements DiscordUtils {
    private static final Logger logger = new Logger(DiscordUtilsImpl.class);
    private static final JsonNode configuration;
    private static final String configFile = "/discordutils_settings.json";
    private final DefaultEmbed defaultEmbed;
    private final Discord discord;
    private final CommandFramework commandFramework;

    public DiscordUtilsImpl(Discord discord) {
        this.discord = discord;
        this.commandFramework = new CommandFrameworkImpl(discord, configuration.path("commands").path("prefix").asText("!"), configuration.path("commands").path("enable_default_help").asBoolean(true));
        this.defaultEmbed = new DefaultEmbedImpl(discord, configuration.has("default_embd") ? configuration.path("default_embed") : JsonHelper.nodeOf(null));
    }

    public DefaultEmbed getDefaultEmbed() {
        return this.defaultEmbed;
    }

    public CommandFramework getCommandFramework() {
        return this.commandFramework;
    }

    public Discord getDiscord() {
        return this.discord;
    }

    private static JsonNode createDefaultConfig() {
        logger.info((Object)"No configuration file /discordutils_settings.json found at resources root. Using default configuration.");
        return JsonHelper.objectNode((Object[])new Object[]{"commands", JsonHelper.objectNode((Object[])new Object[]{"prefix", "!", "enable_default_help", true}), "default_embed", JsonHelper.nodeOf(null)});
    }

    static {
        InputStream configStream = ClassLoader.getSystemResourceAsStream(configFile);
        if (configStream != null) {
            Scanner s = new Scanner(configStream).useDelimiter("\\A");
            configuration = s.hasNext() ? JsonHelper.parse((String)s.next()) : DiscordUtilsImpl.createDefaultConfig();
            try {
                configStream.close();
            }
            catch (IOException e) {
                logger.exception((Throwable)e, "Error closing DiscordUtils initialization file stream.");
            }
        } else {
            configuration = DiscordUtilsImpl.createDefaultConfig();
        }
    }
}

