/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.concurrent.ThreadPool;
import de.kaleidox.crystalshard.core.concurrent.Worker;
import de.kaleidox.crystalshard.internal.InternalInjector;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.IllegalThreadException;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.message.embed.SentEmbed;
import de.kaleidox.crystalshard.util.DefaultEmbed;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DefaultEmbedImpl
implements DefaultEmbed {
    public final Supplier<EmbedDraft> EMPTY_SUPPLIER;
    public final Supplier<Embed.Builder> EMPTY_BUILDER;
    private final List<Consumer<Embed.Builder>> modifiers;
    private final Discord discord;

    DefaultEmbedImpl(Discord discord, JsonNode data) {
        this.discord = discord;
        this.modifiers = new ArrayList<Consumer<Embed.Builder>>();
        this.EMPTY_BUILDER = data.isNull() ? Embed::BUILDER : () -> ((SentEmbed)InternalInjector.newInstance(SentEmbed.class, (Object[])new Object[]{null, data})).toBuilder();
        this.EMPTY_SUPPLIER = () -> this.EMPTY_BUILDER.get().build();
    }

    public EmbedDraft get() {
        if (this.modifiers.isEmpty()) {
            return this.EMPTY_SUPPLIER.get();
        }
        Embed.Builder builder = Embed.BUILDER();
        this.modifiers.forEach(builderConsumer -> builderConsumer.accept(builder));
        return builder.build();
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public DefaultEmbedImpl addModifier(Consumer<Embed.Builder> modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public Embed.Builder getBuilder() {
        if (this.modifiers.isEmpty()) {
            return this.EMPTY_BUILDER.get();
        }
        Embed.Builder builder = this.EMPTY_BUILDER.get();
        this.modifiers.forEach(builderConsumer -> builderConsumer.accept(builder));
        return builder;
    }

    public static EmbedDraft getStatic(Consumer<Embed.Builder> defaultEmbedModifier) {
        ThreadPool.requireBotOwnThread();
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            Embed.Builder builder = ((EmbedDraft)((Worker)thread).getDiscord().getUtilities().getDefaultEmbed().get()).toBuilder();
            defaultEmbedModifier.accept(builder);
            return builder.build();
        }
        throw new IllegalThreadException("The method DefaultEmbed#getStatic may only be called from a bot-own thread, such as in listeners or scheduler tasks. You may not use it from contexts like CompletableFuture#thenAcceptAsync or such.");
    }

    public static EmbedDraft getStatic() {
        ThreadPool.requireBotOwnThread();
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            return (EmbedDraft)((Worker)thread).getDiscord().getUtilities().getDefaultEmbed().get();
        }
        throw new IllegalThreadException("The method DefaultEmbed#getStatic may only be called from a bot-own thread, such as in listeners or scheduler tasks. You may not use it from contexts like CompletableFuture#thenAcceptAsync or such.");
    }

    public static Embed.Builder getBuilderStatic() {
        ThreadPool.requireBotOwnThread();
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            return ((Worker)thread).getDiscord().getUtilities().getDefaultEmbed().getBuilder();
        }
        throw new IllegalThreadException("The method DefaultEmbed#getStatic may only be called from a bot-own thread, such as in listeners or scheduler tasks. You may not use it from contexts like CompletableFuture#thenAcceptAsync or such.");
    }

    public static DefaultEmbedImpl getInstance() {
        ThreadPool.requireBotOwnThread();
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            return (DefaultEmbedImpl)((Worker)thread).getDiscord().getUtilities().getDefaultEmbed();
        }
        throw new IllegalThreadException("The method DefaultEmbed#getStatic may only be called from a bot-own thread, such as in listeners or scheduler tasks. You may not use it from contexts like CompletableFuture#thenAcceptAsync or such.");
    }
}

