/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user.presence;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.user.ServerMemberInternal;
import de.kaleidox.crystalshard.internal.items.user.presence.UserActivityInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.main.items.user.presence.Presence;
import de.kaleidox.crystalshard.main.items.user.presence.UserActivity;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class PresenceInternal
implements Presence {
    private static final ConcurrentHashMap<String, PresenceInternal> instances = new ConcurrentHashMap();
    private final User user;
    private final Server server;
    private UserActivity game;
    private Presence.Status status;

    private PresenceInternal(Discord discord, Server server, JsonNode data) {
        long userId = data.get("user").get("id").asLong();
        this.user = (User)discord.getUserCache().getOrRequest((Object)userId, (Object)userId);
        this.server = server;
        this.game = data.has("game") ? new UserActivityInternal(data.get("game")) : null;
        this.status = Presence.Status.getFromKey((String)data.get("status").asText());
        instances.put(server.getId() + "/" + this.user.getId(), this);
    }

    public ServerMember getUser() {
        return ServerMemberInternal.getInstance(this.user, this.server);
    }

    public Optional<UserActivity> getActivity() {
        return Optional.ofNullable(this.game);
    }

    public Server getServer() {
        return this.server;
    }

    public Presence.Status getStatus() {
        return this.status;
    }

    private Presence updateData(JsonNode data) {
        this.game = data.has("game") ? new UserActivityInternal(data.get("game")) : null;
        this.status = Presence.Status.getFromKey((String)data.get("status").asText());
        return this;
    }

    public static Presence getInstance(Discord discord, JsonNode data) {
        long id = data.get("user").get("id").asLong(-1L);
        assert (id != -1L) : "No valid ID found.";
        long serverId = data.get("guild_id").asLong();
        Server server = (Server)discord.getServerCache().getOrRequest((Object)serverId, (Object)serverId);
        return instances.getOrDefault(server.getId() + "/" + id, new PresenceInternal(discord, server, data)).updateData(data);
    }
}

