/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.user.AuthorWebhook;
import de.kaleidox.crystalshard.main.items.user.Webhook;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

public class WebhookInternal
implements Webhook {
    private static final Logger logger = new Logger(WebhookInternal.class);
    private final long id;
    private final String name;
    private final URL avatarUrl;
    private final Discord discord;

    public WebhookInternal(Discord discord, JsonNode data) {
        URL tempAvatarUrl;
        this.discord = discord;
        this.id = data.get("id").asLong();
        this.name = data.get("username").asText();
        try {
            tempAvatarUrl = data.has("avatar") ? new URL(data.get("avatar").asText()) : null;
        }
        catch (MalformedURLException e) {
            logger.exception((Throwable)e);
            tempAvatarUrl = null;
        }
        this.avatarUrl = tempAvatarUrl;
    }

    public Optional<URL> getAvatarUrl() {
        return Optional.ofNullable(this.avatarUrl);
    }

    public Optional<AuthorWebhook> toAuthorWebhook() {
        if (this instanceof AuthorWebhook) {
            return Optional.of((AuthorWebhook)this);
        }
        return Optional.empty();
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

