/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.user.UserInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.markers.IDPair;
import java.awt.Color;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ServerMemberInternal
extends UserInternal
implements ServerMember {
    private static final ConcurrentHashMap<Long, ConcurrentHashMap<Long, ServerMember>> instances = new ConcurrentHashMap();
    private final Server server;
    private final List<Role> roles;
    private final String nickname;
    private final boolean muted;
    private final boolean deaf;
    private final Instant joined;

    private ServerMemberInternal(Discord discord, Server server, JsonNode data) {
        super((User)discord.getUserCache().getOrRequest((Object)data.get("user").get("id").asLong(), (Object)data.get("user").get("id").asLong()));
        Instant joined1;
        this.server = server;
        this.nickname = data.path("nick").asText(null);
        this.muted = data.path("mute").asBoolean(false);
        this.deaf = data.path("deaf").asBoolean(false);
        try {
            String joined_at = data.get("joined_at").asText();
            joined1 = Instant.parse(joined_at.substring(0, joined_at.length() - 7));
        }
        catch (DateTimeParseException ignored) {
            joined1 = Instant.now();
        }
        this.joined = joined1;
        this.roles = new ArrayList<Role>();
        data.path("roles").forEach(roleIdNode -> this.roles.add((Role)discord.getRoleCache().getOrRequest((Object)roleIdNode.asLong(), (Object)IDPair.of((long)server.getId(), (long)roleIdNode.asLong()))));
        instances.get(super.getId()).put(server.getId(), this);
    }

    public Server getServer() {
        return this.server;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Optional<String> getNickname() {
        return Optional.ofNullable(this.nickname);
    }

    public boolean isMuted() {
        return this.muted;
    }

    public boolean isDeafened() {
        return this.deaf;
    }

    public Instant getJoinedInstant() {
        return this.joined;
    }

    public Optional<Color> getRoleColor() {
        return this.roles.stream().min(Comparator.reverseOrder()).map(Role::getColor);
    }

    public static ServerMember getInstance(User user, Server server) {
        instances.putIfAbsent(user.getId(), new ConcurrentHashMap());
        return instances.get(user.getId()).containsKey(server.getId()) ? instances.get(user.getId()).get(server.getId()) : (ServerMember)CoreInjector.webRequest(ServerMember.class, (Discord)user.getDiscord()).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.GUILD_MEMBER.createUri(new Object[]{server.getId(), user.getId()})).executeAs(node -> ServerMemberInternal.getInstance(user, server, node)).join();
    }

    public static ServerMember getInstance(User user, Server server, JsonNode dataIfAbsent) {
        instances.putIfAbsent(user.getId(), new ConcurrentHashMap());
        return instances.get(user.getId()).getOrDefault(server.getId(), new ServerMemberInternal(user.getDiscord(), server, dataIfAbsent));
    }
}

