/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.core.net.socket.OpCode;
import de.kaleidox.crystalshard.core.net.socket.Payload;
import de.kaleidox.crystalshard.core.net.socket.WebSocketClient;
import de.kaleidox.crystalshard.internal.items.user.UserInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.Self;
import de.kaleidox.crystalshard.main.items.user.presence.Presence;
import de.kaleidox.crystalshard.main.items.user.presence.UserActivity;
import de.kaleidox.util.helpers.JsonHelper;
import java.net.URL;
import java.util.concurrent.CompletableFuture;

public class SelfInternal
extends UserInternal
implements Self {
    private static final Logger logger = new Logger(SelfInternal.class);
    private Presence.Status status;
    private UserActivity.Type type;
    private String title;
    private String url;

    public SelfInternal(Discord discord, JsonNode data) {
        super(discord, data);
    }

    public CompletableFuture<Void> setName(String name) {
        return CoreInjector.webRequest((Discord)this.getDiscord()).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.SELF_INFO.createUri(new Object[0])).setNode(JsonHelper.objectNode((Object[])new Object[0]).set("username", JsonHelper.nodeOf((Object)name))).executeAs(data -> {
            if (!this.discriminator.equals(data.path("discriminator").asText(this.discriminator))) {
                this.discriminator = data.get("discriminator").asText();
            }
            return null;
        }).thenApply(n -> null);
    }

    public CompletableFuture<Void> setNickname(String nickname, Server inServer) {
        return CoreInjector.webRequest((Discord)this.getDiscord()).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.SELF_NICKNAME.createUri(new Object[]{inServer})).setNode((JsonNode)JsonHelper.objectNode((Object[])new Object[]{"nick", nickname})).executeAsVoid();
    }

    public CompletableFuture<Void> setAvatar(URL avatarUrl) {
        return null;
    }

    public CompletableFuture<Void> setStatus(Presence.Status status) {
        this.status = status;
        return this.sendStatus();
    }

    public CompletableFuture<Void> setActivity(UserActivity.Type type, String title) {
        return this.setActivity(type, title, null);
    }

    public CompletableFuture<Void> setActivity(UserActivity.Type type, String title, String url) {
        this.type = type;
        this.title = title;
        this.url = url;
        return this.sendStatus();
    }

    private CompletableFuture<Void> sendStatus() {
        Object[] objectArray;
        WebSocketClient webSocketClient = this.getDiscord().getWebSocket();
        Object[] objectArray2 = new Object[8];
        objectArray2[0] = "since";
        objectArray2[1] = this.status == Presence.Status.IDLE ? Long.valueOf(System.currentTimeMillis()) : null;
        objectArray2[2] = "game";
        Object[] objectArray3 = new Object[5];
        objectArray3[0] = "type";
        objectArray3[1] = this.type.getId();
        objectArray3[2] = "name";
        objectArray3[3] = this.title;
        if (this.url != null) {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = "url";
            objectArray = objectArray4;
            objectArray4[1] = this.url;
        } else {
            objectArray = new Object[]{};
        }
        objectArray3[4] = objectArray;
        objectArray2[3] = JsonHelper.objectNode((Object[])objectArray3);
        objectArray2[4] = "status";
        objectArray2[5] = this.status.getKey();
        objectArray2[6] = "afk";
        objectArray2[7] = false;
        return webSocketClient.sendPayload(Payload.create((OpCode)OpCode.STATUS_UPDATE, (JsonNode)JsonHelper.objectNode((Object[])objectArray2))).thenApply(e -> null);
    }
}

