/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server.interactive;

import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.ServerVoiceChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ServerMemberUpdater
implements ServerMember.Updater {
    private final Server server;
    private final ServerMember member;
    private final List<Role> roles;
    private final Discord discord;
    private String nickname;
    private Boolean muted;
    private Boolean deafened;
    private ServerVoiceChannel channel;

    public ServerMemberUpdater(ServerMember member) {
        this.discord = member.getDiscord();
        this.server = member.getServer();
        this.member = member;
        this.roles = member.getRoles();
    }

    public ServerMember.Updater setNickname(String nickname) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.MANAGE_NICKNAMES)) {
            throw new DiscordPermissionException("Cannot change nickname!", new Permission[]{Permission.MANAGE_NICKNAMES});
        }
        this.nickname = nickname;
        return this;
    }

    public ServerMember.Updater addRole(Role role) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.MANAGE_ROLES)) {
            throw new DiscordPermissionException("Cannot modify roles!", new Permission[]{Permission.MANAGE_ROLES});
        }
        if (role.equals((DiscordItem)this.server.getEveryoneRole())) {
            throw new IllegalArgumentException("Cannot add @everyone Role to a user!");
        }
        this.roles.add(role);
        return this;
    }

    public ServerMember.Updater removeRole(Role role) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.MANAGE_ROLES)) {
            throw new DiscordPermissionException("Cannot modify roles!", new Permission[]{Permission.MANAGE_ROLES});
        }
        if (role.equals((DiscordItem)this.server.getEveryoneRole())) {
            throw new IllegalArgumentException("Cannot remove @everyone Role from a user!");
        }
        this.roles.remove(role);
        return this;
    }

    public ServerMember.Updater setMuted(boolean muted) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.MUTE_MEMBERS)) {
            throw new DiscordPermissionException("Cannot mute other users!", new Permission[]{Permission.MUTE_MEMBERS});
        }
        this.muted = muted;
        return this;
    }

    public ServerMember.Updater setDeafened(boolean deafened) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.DEAFEN_MEMBERS)) {
            throw new DiscordPermissionException("Cannot deafen other nickname!", new Permission[]{Permission.DEAFEN_MEMBERS});
        }
        this.deafened = deafened;
        return this;
    }

    public ServerMember.Updater moveTo(ServerVoiceChannel channel) throws DiscordPermissionException {
        if (!this.server.hasPermission(this.discord, Permission.MOVE_MEMBERS)) {
            throw new DiscordPermissionException("Cannot move other users!", new Permission[]{Permission.MOVE_MEMBERS});
        }
        this.channel = channel;
        return this;
    }

    public CompletableFuture<Void> update() {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object[] objectArray4;
        Object[] objectArray5;
        WebRequest webRequest = CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.GUILD_MEMBER.createUri(new Object[]{this.server, this.member}));
        Object[] objectArray6 = new Object[5];
        if (this.nickname != null) {
            Object[] objectArray7 = new Object[2];
            objectArray7[0] = "nick";
            objectArray5 = objectArray7;
            objectArray7[1] = this.nickname;
        } else {
            objectArray5 = objectArray6[0] = new Object[]{};
        }
        if (this.muted != null) {
            Object[] objectArray8 = new Object[2];
            objectArray8[0] = "mute";
            objectArray4 = objectArray8;
            objectArray8[1] = this.muted;
        } else {
            objectArray4 = objectArray6[1] = new Object[]{};
        }
        if (this.deafened != null) {
            Object[] objectArray9 = new Object[2];
            objectArray9[0] = "deaf";
            objectArray3 = objectArray9;
            objectArray9[1] = this.deafened;
        } else {
            objectArray3 = objectArray6[2] = new Object[]{};
        }
        if (this.channel != null) {
            Object[] objectArray10 = new Object[2];
            objectArray10[0] = "channel_id";
            objectArray2 = objectArray10;
            objectArray10[1] = this.channel.getId();
        } else {
            objectArray2 = objectArray6[3] = new Object[]{};
        }
        if (this.roles != null) {
            Object[] objectArray11 = new Object[2];
            objectArray11[0] = "roles";
            objectArray = objectArray11;
            objectArray11[1] = this.roles.stream().map(DiscordItem::getId).collect(Collectors.toList());
        } else {
            objectArray = new Object[]{};
        }
        objectArray6[4] = objectArray;
        return webRequest.setNode(objectArray6).executeAsVoid();
    }
}

