/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server.emoji;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.emoji.CustomEmoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.markers.IDPair;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class CustomEmojiInternal
implements CustomEmoji {
    private static final ConcurrentHashMap<Long, CustomEmoji> instances = new ConcurrentHashMap();
    private static final Logger logger = new Logger(CustomEmojiInternal.class);
    private final Discord discord;
    private final Server server;
    private final boolean partialData;
    private final long id;
    private final long serverId;
    private String name;
    private boolean requireColons;
    private boolean managed;
    private User creator;
    private List<Role> whitelistedRoles = new ArrayList<Role>();
    private boolean animated;

    public CustomEmojiInternal(Discord discord, Server server, JsonNode data, boolean partialData) {
        logger.deeptrace((Object)("Creating CustomEmoji object for data: " + data));
        this.discord = discord;
        this.server = server;
        this.serverId = server.getId();
        this.partialData = partialData;
        this.id = data.get("id").asLong();
        this.name = data.get("name").asText();
        if (!partialData) {
            data.path("role").forEach(node -> this.whitelistedRoles.add((Role)discord.getRoleCache().getOrCreate(new Object[]{discord, server, node})));
            this.creator = data.has("user") ? (User)discord.getUserCache().getOrCreate(new Object[]{discord, data.path("user")}) : null;
            this.animated = data.path("animated").asBoolean();
            this.managed = data.path("managed").asBoolean();
            this.requireColons = data.path("require_colons").asBoolean();
        }
        instances.put(this.id, this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomEmoji) {
            return ((CustomEmoji)obj).getId() == this.getId();
        }
        return false;
    }

    public String toString() {
        return ":" + this.name + ":";
    }

    public Server getServer() {
        return this.server;
    }

    public CompletableFuture<Void> requestAllData() {
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CUSTOM_EMOJI_SPECIFIC.createUri(new Object[]{this.serverId, this.id})).executeAsNode().thenAccept(data -> {
            data.path("role").forEach(node -> this.whitelistedRoles.add((Role)this.discord.getRoleCache().getOrCreate(new Object[]{this.discord, this.server, node})));
            this.creator = data.has("user") ? (User)this.discord.getUserCache().getOrCreate(new Object[]{this.discord, data.path("user")}) : null;
            this.animated = data.path("animated").asBoolean(false);
            this.managed = data.path("managed").asBoolean(false);
            this.requireColons = data.path("require_colons").asBoolean(false);
        });
    }

    public User getCreator() throws NoSuchElementException {
        if (Objects.nonNull(this.creator)) {
            return this.creator;
        }
        throw new NoSuchElementException("No Creator specified yet. Try using method #requestAllData first.");
    }

    public boolean isAnimated() throws NoSuchElementException {
        if (Objects.nonNull(this.animated)) {
            return this.animated;
        }
        throw new NoSuchElementException("Animated state not specified yet. Try using method #requestAllData first.");
    }

    public boolean isManaged() throws NoSuchElementException {
        if (Objects.nonNull(this.managed)) {
            return this.managed;
        }
        throw new NoSuchElementException("Managed state not specified yet. Try using method #requestAllData first.");
    }

    public boolean requireColons() throws NoSuchElementException {
        if (Objects.nonNull(this.requireColons)) {
            return this.requireColons;
        }
        throw new NoSuchElementException("Require colon state not specified yet. Try using method #requestAllData first.");
    }

    public CompletableFuture<User> requestCreator() {
        if (Objects.nonNull(this.creator)) {
            return CompletableFuture.completedFuture(this.creator);
        }
        return CoreInjector.webRequest(User.class, (Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CUSTOM_EMOJI_SPECIFIC.createUri(new Object[]{this.serverId, this.id})).executeAs(node -> (User)this.discord.getUserCache().getOrCreate(new Object[]{this.discord, node.get("user")}));
    }

    public CompletableFuture<Boolean> requestIsAnimated() {
        if (Objects.nonNull(this.animated)) {
            return CompletableFuture.completedFuture(this.animated);
        }
        return CoreInjector.webRequest(Boolean.class, (Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CUSTOM_EMOJI_SPECIFIC.createUri(new Object[]{this.serverId, this.id})).executeAs(node -> {
            this.animated = node.get("animated").asBoolean();
            return this.animated;
        });
    }

    public CompletableFuture<Boolean> requestIsManaged() {
        if (Objects.nonNull(this.managed)) {
            return CompletableFuture.completedFuture(this.managed);
        }
        return CoreInjector.webRequest(Boolean.class, (Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CUSTOM_EMOJI_SPECIFIC.createUri(new Object[]{this.serverId, this.id})).executeAs(node -> {
            this.managed = node.get("managed").asBoolean();
            return this.managed;
        });
    }

    public CompletableFuture<Boolean> requestRequireColons() {
        if (Objects.nonNull(this.requireColons)) {
            return CompletableFuture.completedFuture(this.requireColons);
        }
        return CoreInjector.webRequest(Boolean.class, (Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CUSTOM_EMOJI_SPECIFIC.createUri(new Object[]{this.serverId, this.id})).executeAs(node -> {
            this.requireColons = node.get("require_colons").asBoolean();
            return this.requireColons;
        });
    }

    public String toDiscordPrintable() {
        return "<:" + (this.requestIsAnimated().join() != false ? "a:" : "") + this.name + ":" + this.id + ">";
    }

    public String toAlias() {
        return this.name;
    }

    public Discord getDiscord() {
        return null;
    }

    public long getId() {
        return this.id;
    }

    public String getMentionTag() {
        return this.toDiscordPrintable();
    }

    public Cache<CustomEmoji, Long, IDPair> getCache() {
        return this.discord.getEmojiCache();
    }

    public Set<EditTrait<CustomEmoji>> updateData(JsonNode data) {
        return null;
    }
}

