/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server;

import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.channel.ChannelBuilderInternal;
import de.kaleidox.crystalshard.internal.items.role.RoleBuilderInternal;
import de.kaleidox.crystalshard.internal.util.Container;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.DefaultMessageNotificationLevel;
import de.kaleidox.crystalshard.main.items.server.ExplicitContentFilterLevel;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.ServerComponent;
import de.kaleidox.crystalshard.main.items.server.VerificationLevel;
import de.kaleidox.crystalshard.main.items.server.VoiceRegion;
import de.kaleidox.util.FileType;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ServerBuilderInternal
implements Server.Builder {
    private final Discord discord;
    private String name;
    private VoiceRegion region;
    private File icon;
    private VerificationLevel verificationLevel;
    private DefaultMessageNotificationLevel notificationLevel;
    private ExplicitContentFilterLevel contentFilter;
    private List<RoleBuilderInternal> roleBuilders;
    private List<ServerChannel.Builder> channelBuilders;

    public ServerBuilderInternal(Discord discord) {
        this.discord = discord;
        this.roleBuilders = new ArrayList<RoleBuilderInternal>();
        this.channelBuilders = new ArrayList<ServerChannel.Builder>();
    }

    public Server.Builder setName(String name) {
        this.name = name;
        return this;
    }

    public Server.Builder setRegion(VoiceRegion region) {
        this.region = region;
        return this;
    }

    public Server.Builder setIcon(File icon) {
        this.icon = icon;
        return this;
    }

    public Server.Builder setVerificationLevel(VerificationLevel level) {
        this.verificationLevel = level;
        return this;
    }

    public Server.Builder setDefaultNotificationLevel(DefaultMessageNotificationLevel level) {
        this.notificationLevel = level;
        return this;
    }

    public Server.Builder setExplicitContentFilter(ExplicitContentFilterLevel level) {
        this.contentFilter = level;
        return this;
    }

    public Server.Builder addRole(Role.Builder roleBuilder) {
        this.roleBuilders.add((RoleBuilderInternal)roleBuilder);
        return this;
    }

    public Server.Builder addChannel(ServerChannel.Builder channelBuilder) {
        this.channelBuilders.add(channelBuilder);
        return this;
    }

    public Server.Builder add(ServerComponent component) {
        if (component instanceof Role.Builder) {
            return this.addRole((Role.Builder)component);
        }
        if (component instanceof ServerChannel.Builder) {
            return this.addChannel((ServerChannel.Builder)component);
        }
        throw new AssertionError((Object)("Unknown component: " + component));
    }

    public CompletableFuture<Server> build() {
        return CoreInjector.webRequest(Server.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD.createUri(new Object[0])).setNode(new Object[]{"name", this.name, "region", this.region.getRegionKey(), "icon", Container.encodeBase64(this.icon, (FileType)FileType.IMAGE.JPEG, new Dimension(128, 128)), "verification_level", this.verificationLevel.getId(), "default_message_notifications", this.notificationLevel.getId(), "explicit_content_filter", this.contentFilter.getId(), "roles", this.roleBuilders.stream().map(RoleBuilderInternal::toJsonNode).collect(Collectors.toList()), "channels", this.channelBuilders.stream().map(builder -> ((ChannelBuilderInternal.ServerChannelBuilder)builder).toPartialJsonNode()).collect(Collectors.toList())}).executeAs(node -> (Server)this.discord.getServerCache().getOrCreate(new Object[]{this.discord, node}));
    }
}

