/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message.reaction;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.server.emoji.UnicodeEmojiInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.reaction.Reaction;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.MapHelper;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionInternal
implements Reaction {
    private static final ConcurrentHashMap<ReactionCriteria, Reaction> instances = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ReactionCriteria, Integer> counts = new ConcurrentHashMap();
    private static final Logger logger = new Logger(ReactionInternal.class);
    private final Discord discord;
    private final boolean me;
    private final Emoji emoji;
    private final Message message;
    private final User user;

    ReactionInternal(Discord discord, Message message, User user, JsonNode data) {
        logger.deeptrace((Object)("Creating Reaction object for data: " + data));
        this.discord = discord;
        this.message = message;
        this.user = user;
        this.me = data.path("me").asBoolean(false);
        this.emoji = data.get("emoji").get("id").isNull() ? new UnicodeEmojiInternal(discord, data.get("emoji"), true) : (Emoji)discord.getEmojiCache().getOrCreate(new Object[]{discord, message.getChannel().toServerChannel().map(ServerChannel::getServer).orElseThrow(AssertionError::new), data.get("emoji"), true});
        ReactionCriteria criteria = new ReactionCriteria(message, this.emoji);
        instances.put(criteria, this);
        counts.put(criteria, data.path("count").asInt(0));
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public Emoji getEmoji() {
        return this.emoji;
    }

    public User getUser() {
        return this.user;
    }

    public Message getMessage() {
        return this.message;
    }

    public int getCount() {
        ReactionCriteria criteria = new ReactionCriteria(this.message, this.emoji);
        return counts.getOrDefault(criteria, 0);
    }

    public void remove() {
    }

    private Reaction changeCount(int delta) {
        ReactionCriteria criteria = new ReactionCriteria(this.message, this.emoji);
        counts.put(criteria, delta == Integer.MIN_VALUE ? 0 : counts.getOrDefault(criteria, 0) + delta);
        return this;
    }

    public String toString() {
        return "Reaction at " + this.message + " with " + this.emoji;
    }

    public static Reaction getInstance(@Nullable Server server, @NotNull Message message, @Nullable User user, @NotNull JsonNode data, int delta) {
        Emoji emoji = Emoji.of((Discord)message.getDiscord(), (Server)server, (JsonNode)data.get("emoji"));
        ReactionCriteria criteria = new ReactionCriteria(message, emoji);
        return ((ReactionInternal)MapHelper.getEquals(instances, (Object)criteria, (Object)new ReactionInternal(message.getDiscord(), message, user, data))).changeCount(delta);
    }

    private static class ReactionCriteria {
        private final Message message;
        private final Emoji emoji;

        public ReactionCriteria(Message message, Emoji emoji) {
            this.message = message;
            this.emoji = emoji;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReactionCriteria) {
                return ((ReactionCriteria)obj).message.equals((DiscordItem)this.message) && ((ReactionCriteria)obj).emoji.equals((Object)this.emoji);
            }
            return false;
        }
    }
}

