/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message.embed;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.message.embed.EmbedDraftInternal;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.message.embed.SentEmbed;
import de.kaleidox.util.helpers.UrlHelper;
import java.awt.Color;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SentEmbedInternal
implements SentEmbed {
    private final String title;
    private final String description;
    private final URL url;
    private final Instant timestamp;
    private final Color color;
    private final SentEmbed.Footer footer;
    private final SentEmbed.Image image;
    private final SentEmbed.Thumbnail thumbnail;
    private final SentEmbed.Author author;
    private final SentEmbed.Video video;
    private final SentEmbed.Provider provider;
    private final ArrayList<SentEmbed.Field> fields;
    private final Message message;

    public SentEmbedInternal(Message message, JsonNode data) {
        this.message = message;
        this.title = data.path("title").asText(null);
        this.description = data.path("description").asText(null);
        this.url = UrlHelper.orNull((String)data.path("url").asText(null));
        this.timestamp = data.has("timestamp") ? Instant.parse(data.path("timestamp").asText()) : null;
        this.color = data.has("color") ? new Color(data.path("color").asInt()) : null;
        this.footer = data.has("footer") ? new Footer(data.path("footer")) : null;
        this.image = data.has("image") ? new Image(data.path("image")) : null;
        this.thumbnail = data.has("thumbnail") ? new Thumbnail(data.path("thumbnail")) : null;
        this.author = data.has("author") ? new Author(data.path("author")) : null;
        this.provider = data.has("provider") ? new Provider(data.path("provider")) : null;
        this.video = data.has("video") ? new Video(data.path("video")) : null;
        this.fields = new ArrayList();
        for (JsonNode node : data.path("fields")) {
            this.fields.add(new Field(node));
        }
    }

    public EmbedDraft toEmbedDraft() {
        return this.toBuilder().build();
    }

    public Embed.Builder toBuilder() {
        Embed.Builder builder = Embed.BUILDER().setTitle(this.title).setDescription(this.description).setUrl(Objects.nonNull(this.url) ? this.url.toExternalForm() : null).setTimestamp(this.timestamp).setColor(this.color).setFooter(Objects.nonNull(this.footer) ? this.footer.toDraft() : null).setImage(Objects.nonNull(this.image) ? this.image.toDraft() : null).setThumbnail(Objects.nonNull(this.thumbnail) ? this.thumbnail.toDraft() : null).setAuthor(Objects.nonNull(this.author) ? this.author.toDraft() : null);
        this.fields.forEach(field -> builder.addField(field.toDraft()));
        return builder;
    }

    public Message getMessage() {
        return this.message;
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<URL> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<Color> getColor() {
        return Optional.ofNullable(this.color);
    }

    public Optional<SentEmbed.Footer> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    public Optional<SentEmbed.Image> getImage() {
        return Optional.ofNullable(this.image);
    }

    public Optional<SentEmbed.Author> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public Optional<SentEmbed.Thumbnail> getThumbail() {
        return Optional.ofNullable(this.thumbnail);
    }

    public Optional<SentEmbed.Video> getVideo() {
        return Optional.ofNullable(this.video);
    }

    public Optional<SentEmbed.Provider> getProvider() {
        return Optional.ofNullable(this.provider);
    }

    public Collection<SentEmbed.Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Updater getUpdater() throws IllegalAccessException {
        if (!this.message.getAuthor().isYourself()) {
            throw new IllegalAccessException("You cannot edit someone elses embed!");
        }
        return new Updater(this);
    }

    public CompletableFuture<SentEmbed> setTitle(String title) {
        Embed.Builder builder = this.toBuilder();
        builder.setTitle(title);
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> setDescription(String description) {
        Embed.Builder builder = this.toBuilder();
        builder.setDescription(description);
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> setUrl(String url) {
        Embed.Builder builder = this.toBuilder();
        builder.setUrl(url);
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> setTimestamp(Instant timestamp) {
        Embed.Builder builder = this.toBuilder();
        builder.setTimestamp(timestamp);
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> setColor(Color color) {
        Embed.Builder builder = this.toBuilder();
        builder.setColor(color);
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> modifyFields(Consumer<Collection<EmbedDraft.EditableField>> fieldModifier) {
        List<EmbedDraft.EditableField> fields = this.getFields().stream().map(SentEmbed.Field::toDraft).map(EmbedDraftInternal.EditableField::new).collect(Collectors.toList());
        fieldModifier.accept(fields);
        Embed.Builder builder = this.toBuilder();
        builder.removeAllFields();
        fields.forEach(arg_0 -> ((Embed.Builder)builder).addField(arg_0));
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public CompletableFuture<SentEmbed> modifyFields(Predicate<SentEmbed.Field> tester, Consumer<EmbedDraft.EditableField> fieldModifier) {
        Embed.Builder builder = this.toBuilder();
        builder.removeAllFields();
        this.getFields().stream().map(field -> {
            EmbedDraft.Field draftField = field.toDraft();
            if (tester.test((SentEmbed.Field)field)) {
                EmbedDraftInternal.EditableField editableField = new EmbedDraftInternal.EditableField(draftField);
                fieldModifier.accept(editableField);
                return editableField;
            }
            return draftField;
        }).forEach(arg_0 -> ((Embed.Builder)builder).addField(arg_0));
        return this.message.edit(builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
    }

    public class Provider
    implements SentEmbed.Provider {
        public Provider(JsonNode data) {
        }

        public String getName() {
            return null;
        }

        public Optional<URL> getUrl() {
            return Optional.empty();
        }
    }

    public class Video
    implements SentEmbed.Video {
        public Video(JsonNode data) {
        }

        public Optional<URL> getUrl() {
            return Optional.empty();
        }
    }

    public class Field
    implements SentEmbed.Field {
        private final String title;
        private final String text;
        private final boolean inline;

        public Field(JsonNode data) {
            this.title = data.path("title").asText();
            this.text = data.path("text").asText();
            this.inline = data.path("inline").asBoolean(false);
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }

        public boolean isInline() {
            return this.inline;
        }
    }

    public class Thumbnail
    implements SentEmbed.Thumbnail {
        public Thumbnail(JsonNode data) {
        }

        public Optional<URL> getUrl() {
            return Optional.empty();
        }
    }

    public class Author
    implements SentEmbed.Author {
        public Author(JsonNode data) {
        }

        public Optional<URL> getUrl() {
            return Optional.empty();
        }

        public Optional<URL> getIconUrl() {
            return Optional.empty();
        }

        public String getName() {
            return null;
        }
    }

    public class Image
    implements SentEmbed.Image {
        public Image(JsonNode data) {
        }

        public Optional<URL> getUrl() {
            return Optional.empty();
        }
    }

    public class Footer
    implements SentEmbed.Footer {
        public Footer(JsonNode data) {
        }

        public String getText() {
            return null;
        }

        public Optional<URL> getIconUrl() {
            return Optional.empty();
        }
    }

    public class Updater
    implements SentEmbed.Updater {
        private final Embed.Builder builder;
        private final Message message;

        public Updater(SentEmbed embed) {
            this.builder = embed.toBuilder();
            this.message = embed.getMessage();
        }

        public SentEmbed.Updater setTitle(String title) {
            this.builder.setTitle(title);
            return this;
        }

        public SentEmbed.Updater setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        public SentEmbed.Updater setUrl(String url) {
            this.builder.setUrl(url);
            return this;
        }

        public SentEmbed.Updater setTimestamp(Instant timestamp) {
            this.builder.setTimestamp(timestamp);
            return this;
        }

        public SentEmbed.Updater setColor(Color color) {
            this.builder.setColor(color);
            return this;
        }

        public SentEmbed.Updater modifyFields(Consumer<Collection<EmbedDraft.EditableField>> fieldModifier) {
            Collection fields = this.builder.getFields().stream().map(EmbedDraftInternal.EditableField::new).collect(Collectors.toList());
            fieldModifier.accept(fields);
            this.builder.removeAllFields();
            fields.forEach(arg_0 -> ((Embed.Builder)this.builder).addField(arg_0));
            return this;
        }

        public SentEmbed.Updater modifyFields(Predicate<EmbedDraft.Field> tester, Consumer<EmbedDraft.EditableField> fieldModifier) {
            Collection fields = this.builder.getFields().stream().map(EmbedDraftInternal.EditableField::new).collect(Collectors.toList());
            this.builder.removeAllFields();
            fields.stream().map(field -> {
                if (tester.test((EmbedDraft.Field)field)) {
                    EmbedDraftInternal.EditableField editableField = new EmbedDraftInternal.EditableField((EmbedDraft.Field)field);
                    fieldModifier.accept(editableField);
                    return editableField;
                }
                return field;
            }).forEach(arg_0 -> ((Embed.Builder)this.builder).addField(arg_0));
            return this;
        }

        public CompletableFuture<SentEmbed> update() {
            return this.message.edit(this.builder.build()).thenApply(msg -> (SentEmbed)msg.getEmbed().orElseThrow(AssertionError::new));
        }
    }
}

