/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.internal.items.message.AttachmentInternal;
import de.kaleidox.crystalshard.internal.items.message.MessageActivityInternal;
import de.kaleidox.crystalshard.internal.items.message.MessageApplicationInternal;
import de.kaleidox.crystalshard.internal.items.message.embed.SentEmbedInternal;
import de.kaleidox.crystalshard.internal.items.message.reaction.ReactionInternal;
import de.kaleidox.crystalshard.internal.items.user.AuthorUserInternal;
import de.kaleidox.crystalshard.internal.items.user.AuthorWebhookInternal;
import de.kaleidox.crystalshard.internal.items.user.UserInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.message.MessageAttachableListener;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.channel.TextChannel;
import de.kaleidox.crystalshard.main.items.message.Attachment;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageActivity;
import de.kaleidox.crystalshard.main.items.message.MessageApplication;
import de.kaleidox.crystalshard.main.items.message.MessageType;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.message.embed.SentEmbed;
import de.kaleidox.crystalshard.main.items.message.reaction.Reaction;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.emoji.CustomEmoji;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.server.emoji.UnicodeEmoji;
import de.kaleidox.crystalshard.main.items.user.Author;
import de.kaleidox.crystalshard.main.items.user.AuthorUser;
import de.kaleidox.crystalshard.main.items.user.AuthorWebhook;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.JsonHelper;
import de.kaleidox.util.markers.IDPair;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class MessageInternal
implements Message {
    private static final ConcurrentHashMap<Long, Message> instances = new ConcurrentHashMap();
    private static final Logger logger = new Logger(MessageInternal.class);
    private final long id;
    private final long channelId;
    private final Author author;
    private final String contentRaw;
    private final Instant timestamp;
    private final Instant editedTimestamp;
    private final boolean tts;
    private final boolean mentionsEveryone;
    private final boolean pinned;
    private final MessageType type;
    private final MessageActivity activity;
    private final MessageApplication application;
    private final List<User> userMentions = new ArrayList<User>();
    private final List<Role> roleMentions = new ArrayList<Role>();
    private final List<Attachment> attachments = new ArrayList<Attachment>();
    private final List<SentEmbed> embeds = new ArrayList<SentEmbed>();
    private final List<Reaction> reactions = new ArrayList<Reaction>();
    private final Server server;
    private final Discord discord;
    private final List<Emoji> emojis = new ArrayList<Emoji>();
    private final List<Channel> channelMentions = new ArrayList<Channel>();
    private final TextChannel channel;
    private Collection<ListenerManager<? extends MessageAttachableListener>> listenerManagers;

    public MessageInternal(Discord discord, JsonNode data) {
        Instant timestamp1;
        logger.deeptrace((Object)("Creating message object for data: " + data.toString()));
        this.discord = discord;
        this.id = data.get("id").asLong();
        this.channelId = data.get("channel_id").asLong();
        this.channel = (TextChannel)((Channel)discord.getChannelCache().getOrRequest((Object)this.channelId, (Object)this.channelId)).toTextChannel().get();
        this.server = this.channel.toServerChannel().isPresent() ? this.channel.toServerChannel().map(ServerChannel::getServer).get() : null;
        this.contentRaw = data.get("content").asText();
        try {
            timestamp1 = Instant.parse(data.get("timestamp").asText());
        }
        catch (DateTimeException ignored) {
            timestamp1 = null;
        }
        this.timestamp = timestamp1;
        this.editedTimestamp = data.has("edited_timestamp") && !data.get("edited_timestamp").isNull() ? Instant.parse(data.get("edited_timestamp").asText()) : null;
        this.tts = data.get("tts").asBoolean(false);
        this.mentionsEveryone = data.get("tts").asBoolean(false);
        this.pinned = data.get("pinned").asBoolean(false);
        this.type = MessageType.getTypeById((int)data.get("type").asInt());
        this.activity = data.has("activity") ? new MessageActivityInternal(data.get("activity")) : null;
        this.application = data.has("application") ? new MessageApplicationInternal(data.get("application")) : null;
        this.author = !data.has("webhook_id") ? new AuthorUserInternal(discord, this, data.get("author")) : new AuthorWebhookInternal(discord, this, data.get("author"));
        for (JsonNode mention : data.get("mentions")) {
            this.userMentions.add(new UserInternal(discord, mention));
        }
        for (JsonNode role : data.get("mention_roles")) {
            this.roleMentions.add((Role)discord.getRoleCache().getOrCreate(new Object[]{discord, this.server, role}));
        }
        for (JsonNode attachment : data.get("attachments")) {
            this.attachments.add(new AttachmentInternal(attachment));
        }
        for (JsonNode embed : data.get("embeds")) {
            this.embeds.add(new SentEmbedInternal(this, embed));
        }
        if (data.has("reactions")) {
            for (JsonNode reaction : data.get("reactions")) {
                this.reactions.add(ReactionInternal.getInstance(this.server, this, null, reaction, 0));
            }
        }
        this.listenerManagers = new ArrayList<ListenerManager<? extends MessageAttachableListener>>();
        instances.put(this.id, this);
    }

    public Author getAuthor() {
        return this.author;
    }

    public Optional<AuthorUser> getAuthorAsUser() {
        return this.author.toAuthorUser();
    }

    public Optional<AuthorWebhook> getAuthorAsWebhook() {
        return this.author.toAuthorWebhook();
    }

    public String getContent() {
        return this.contentRaw;
    }

    public String getReadableContent() {
        return null;
    }

    public String getTextContent() {
        return null;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<Instant> getEditedTimestamp() {
        return Optional.ofNullable(this.editedTimestamp);
    }

    public boolean isTTS() {
        return this.tts;
    }

    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    public boolean isPrivate() {
        return this.server != null;
    }

    public MessageType getType() {
        return this.type;
    }

    public Optional<MessageActivity> getActivity() {
        return Optional.ofNullable(this.activity);
    }

    public Optional<MessageApplication> getApplication() {
        return Optional.ofNullable(this.application);
    }

    public List<User> getUserMentions() {
        return Collections.unmodifiableList(this.userMentions);
    }

    public List<Role> getRoleMentions() {
        return Collections.unmodifiableList(this.roleMentions);
    }

    public List<Channel> getChannelMentions() {
        return Collections.unmodifiableList(this.channelMentions);
    }

    public List<Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<Reaction> getReactions() {
        return Collections.unmodifiableList(this.reactions);
    }

    public List<Emoji> getEmojis() {
        return Collections.unmodifiableList(this.emojis);
    }

    public List<CustomEmoji> getCustomEmojis() {
        return null;
    }

    public List<UnicodeEmoji> getUnicodeEmojis() {
        return null;
    }

    public CompletableFuture<Message> edit(String newContent) {
        return null;
    }

    public CompletableFuture<Message> edit(EmbedDraft embedDraft) {
        return null;
    }

    public CompletableFuture<Void> removeAllReactions() {
        if (!this.channel.hasPermission(this.discord, Permission.MANAGE_MESSAGES)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot remove other peoples reactions.", new Permission[]{Permission.MANAGE_MESSAGES}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.REACTIONS.createUri(new Object[]{this.channelId, this.id})).executeAsVoid();
    }

    public CompletableFuture<Void> removeReactionsByEmoji(Emoji ... emojis) {
        if (!this.channel.hasPermission(this.discord, Permission.MANAGE_MESSAGES)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot remove other peoples reactions.", new Permission[]{Permission.MANAGE_MESSAGES}));
        }
        ArrayList deletions = new ArrayList();
        this.reactions.stream().filter(reaction -> Stream.of(emojis).anyMatch(emoji -> reaction.getEmoji().equals(emoji))).forEach(reaction -> deletions.add(CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.REACTION_USER.createUri(new Object[]{this.channelId, this.id, reaction.getEmoji().toDiscordPrintable(), reaction.getUser()})).executeAsVoid()));
        return CompletableFuture.allOf(deletions.toArray(new CompletableFuture[0]));
    }

    public CompletableFuture<Void> removeReactionsByUser(User ... users) {
        if (!this.channel.hasPermission(this.discord, Permission.MANAGE_MESSAGES)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot remove other peoples reactions.", new Permission[]{Permission.MANAGE_MESSAGES}));
        }
        ArrayList deletions = new ArrayList();
        this.reactions.stream().filter(reaction -> Stream.of(users).anyMatch(user -> reaction.getUser().equals((DiscordItem)user))).forEach(reaction -> deletions.add(CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.REACTION_USER.createUri(new Object[]{this.channelId, this.id, reaction.getEmoji().toDiscordPrintable(), reaction.getUser()})).executeAsVoid()));
        return CompletableFuture.allOf(deletions.toArray(new CompletableFuture[0]));
    }

    public Message.BulkDelete getBulkDelete() {
        return new BulkDeleteInternal(this.discord).addMessage(this);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public CompletableFuture<Message> pin() {
        return CoreInjector.webRequest(Message.class, (Discord)this.discord).setMethod(HttpMethod.PUT).setUri((RequestURI)DiscordEndpoint.PIN_MESSAGE.createUri(new Object[]{this.channelId, this.id})).executeAs(node -> this);
    }

    public CompletableFuture<Message> unpin() {
        return CoreInjector.webRequest(Message.class, (Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.PIN_MESSAGE.createUri(new Object[]{this.channelId, this.id})).executeAs(node -> this);
    }

    public CompletableFuture<Void> addReaction(String emojiPrintable) {
        if (!this.channel.hasPermission(this.discord, Permission.READ_MESSAGE_HISTORY)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot read message history!", new Permission[]{Permission.READ_MESSAGE_HISTORY}));
        }
        if (this.getReactions().stream().map(Reaction::getEmoji).map(Emoji::toDiscordPrintable).noneMatch(emojiPrintable::equalsIgnoreCase) && !this.channel.hasPermission(this.discord, Permission.ADD_REACTIONS)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot add new reactions!", new Permission[]{Permission.ADD_REACTIONS}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.PUT).setUri((RequestURI)DiscordEndpoint.REACTION_OWN.createUri(new Object[]{this.channelId, this.id, emojiPrintable})).executeAsVoid();
    }

    public List<SentEmbed> getEmbeds() {
        return Collections.unmodifiableList(this.embeds);
    }

    public CompletableFuture<Void> delete(String reason) {
        if (this.channel.toServerChannel().isPresent() && !this.author.isYourself() && !this.channel.hasPermission(this.discord, Permission.MANAGE_MESSAGES)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot delete " + this.toString() + "; you are not the author.", new Permission[]{Permission.MANAGE_MESSAGES}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.MESSAGE_SPECIFIC.createUri(new Object[]{this.channelId, this.id})).executeAsVoid();
    }

    public TextChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "Message with ID [" + this.id + "]";
    }

    public <C extends MessageAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance((DiscordInternal)this.discord, listener);
        this.listenerManagers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(MessageAttachableListener listener) {
        return null;
    }

    public Collection<ListenerManager<? extends MessageAttachableListener>> getListenerManagers() {
        return this.listenerManagers;
    }

    public Collection<MessageAttachableListener> getAttachedListeners() {
        return null;
    }

    public Discord getDiscord() {
        return null;
    }

    public long getId() {
        return 0L;
    }

    public Cache<Message, Long, IDPair> getCache() {
        return this.discord.getMessageCache();
    }

    public Set<EditTrait<Message>> updateData(JsonNode data) {
        return null;
    }

    public static class BulkDeleteInternal
    implements Message.BulkDelete {
        private final Discord discord;
        private Long channelId = null;
        private List<Long> ids;

        public BulkDeleteInternal(Discord discord) {
            this.discord = discord;
            this.ids = new ArrayList<Long>();
        }

        public Message.BulkDelete setChannel(long channelId) {
            this.channelId = channelId;
            return this;
        }

        public Message.BulkDelete addMessage(Message message) {
            this.addId(message.getId());
            return this;
        }

        public Message.BulkDelete addMessages(Message ... messages) {
            for (Message message : messages) {
                this.addMessage(message);
            }
            return this;
        }

        public Message.BulkDelete addId(long id) {
            if (this.ids.size() >= 100) {
                throw new IllegalArgumentException("BulkDelete only allowed with up to 100 Messages!");
            }
            this.ids.add(id);
            return this;
        }

        public Message.BulkDelete addIds(long ... ids) {
            for (long id : ids) {
                this.addId(id);
            }
            return this;
        }

        public CompletableFuture<Void> deleteAll() {
            Objects.requireNonNull(this.channelId, "ChannelID for BulkDelete must not be NULL!");
            if (this.ids.size() >= 100) {
                throw new IllegalArgumentException("BulkDelete only allowed with up to 100 Messages!");
            }
            return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.MESSAGES_BULK_DELETE.createUri(new Object[]{this.channelId})).setNode((JsonNode)JsonHelper.objectNode((Object[])new Object[]{"messages", this.ids})).executeAsVoid();
        }
    }
}

