/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.channel.ChannelInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.channel.TextChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class TextChannelInternal
extends ChannelInternal
implements TextChannel {
    final ConcurrentHashMap<Long, Message> messages = new ConcurrentHashMap();
    final ConcurrentHashMap<Long, Message> pinned = new ConcurrentHashMap();

    TextChannelInternal(Discord discord, JsonNode data) {
        super(discord, data);
    }

    public Collection<Message> getPinnedMessages() {
        return this.pinned.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void updatePinned(Message message) {
        if (message.isPinned()) {
            this.pinned.put(message.getId(), message);
        } else {
            this.pinned.remove(message.getId());
        }
    }
}

