/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.permission.PermissionOverrideInternal;
import de.kaleidox.crystalshard.internal.items.server.interactive.InviteInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelCategory;
import de.kaleidox.crystalshard.main.items.channel.ChannelType;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerVoiceChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.interactive.Invite;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ChannelBuilderInternal {

    public static class ServerVoiceChannelBuilder
    extends ServerChannelBuilder<ServerVoiceChannel.Builder, ServerVoiceChannel>
    implements ServerVoiceChannel.Builder {
        protected Integer bitrate;
        protected Integer limit;

        public ServerVoiceChannelBuilder(Discord discord) {
            super(discord, ChannelType.GUILD_VOICE);
            this.setSuperType(this);
        }

        public ServerVoiceChannel.Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return (ServerVoiceChannel.Builder)this.superType;
        }

        public ServerVoiceChannel.Builder setUserLimit(int limit) {
            this.limit = limit;
            return null;
        }

        public CompletableFuture<ServerVoiceChannel> build() {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            if (!this.server.hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot create channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            if (this.name == null) {
                throw new IllegalArgumentException("No channel name set!");
            }
            WebRequest webRequest = CoreInjector.webRequest(ServerVoiceChannel.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD_CHANNEL.createUri(new Object[]{this.server}));
            Object[] objectArray4 = new Object[9];
            objectArray4[0] = "type";
            objectArray4[1] = this.type;
            objectArray4[2] = "name";
            objectArray4[3] = this.name;
            if (this.bitrate != null) {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = "bitrate";
                objectArray3 = objectArray5;
                objectArray5[1] = this.bitrate;
            } else {
                objectArray3 = objectArray4[4] = new Object[]{};
            }
            if (this.limit != null) {
                Object[] objectArray6 = new Object[2];
                objectArray6[0] = "user_limit";
                objectArray2 = objectArray6;
                objectArray6[1] = this.limit;
            } else {
                objectArray2 = objectArray4[5] = new Object[]{};
            }
            if (this.category != null) {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "parent_id";
                objectArray = objectArray7;
                objectArray7[1] = this.category.getId();
            } else {
                objectArray = new Object[]{};
            }
            objectArray4[6] = objectArray;
            objectArray4[7] = "permission_overwrites";
            objectArray4[8] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray4).executeAs(node -> (ServerVoiceChannel)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toServerVoiceChannel().orElseThrow(AssertionError::new));
        }
    }

    public static class ServerTextChannelBuilder
    extends ServerChannelBuilder<ServerTextChannel.Builder, ServerTextChannel>
    implements ServerTextChannel.Builder {
        protected String topic;
        protected Boolean nsfw;

        public ServerTextChannelBuilder(Discord discord) {
            super(discord, ChannelType.GUILD_TEXT);
            this.setSuperType(this);
        }

        public ServerTextChannel.Builder setTopic(String topic) {
            this.topic = topic;
            return (ServerTextChannel.Builder)this.superType;
        }

        public ServerTextChannel.Builder setNSFW(boolean nsfw) {
            this.nsfw = nsfw;
            return (ServerTextChannel.Builder)this.superType;
        }

        public CompletableFuture<ServerTextChannel> build() {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            if (!this.server.hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot create channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            if (this.name == null) {
                throw new IllegalArgumentException("No channel name set!");
            }
            WebRequest webRequest = CoreInjector.webRequest(ServerTextChannel.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD_CHANNEL.createUri(new Object[]{this.server}));
            Object[] objectArray4 = new Object[9];
            objectArray4[0] = "type";
            objectArray4[1] = this.type;
            objectArray4[2] = "name";
            objectArray4[3] = this.name;
            if (this.topic != null) {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = "topic";
                objectArray3 = objectArray5;
                objectArray5[1] = this.topic;
            } else {
                objectArray3 = objectArray4[4] = new Object[]{};
            }
            if (this.nsfw != null) {
                Object[] objectArray6 = new Object[2];
                objectArray6[0] = "nsfw";
                objectArray2 = objectArray6;
                objectArray6[1] = this.nsfw;
            } else {
                objectArray2 = objectArray4[5] = new Object[]{};
            }
            if (this.category != null) {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "parent_id";
                objectArray = objectArray7;
                objectArray7[1] = this.category.getId();
            } else {
                objectArray = new Object[]{};
            }
            objectArray4[6] = objectArray;
            objectArray4[7] = "permission_overwrites";
            objectArray4[8] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray4).executeAs(node -> (ServerTextChannel)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toServerTextChannel().orElseThrow(AssertionError::new));
        }
    }

    public static class ServerCategoryBuilder
    extends ServerChannelBuilder<ChannelCategory.Builder, ChannelCategory>
    implements ChannelCategory.Builder {
        public ServerCategoryBuilder(Discord discord) {
            super(discord, ChannelType.GUILD_CATEGORY);
            this.setSuperType(this);
        }

        @Override
        public ChannelCategory.Builder setCategory(ChannelCategory category) {
            throw new UnsupportedOperationException("Cannot set a category to a category!");
        }

        public CompletableFuture<ChannelCategory> build() {
            Object[] objectArray;
            if (!this.server.hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot create channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            if (this.name == null) {
                throw new IllegalArgumentException("No channel name set!");
            }
            WebRequest webRequest = CoreInjector.webRequest(ChannelCategory.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD_CHANNEL.createUri(new Object[]{this.server}));
            Object[] objectArray2 = new Object[7];
            objectArray2[0] = "type";
            objectArray2[1] = this.type;
            objectArray2[2] = "name";
            objectArray2[3] = this.name;
            if (this.category != null) {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = "parent_id";
                objectArray = objectArray3;
                objectArray3[1] = this.category.getId();
            } else {
                objectArray = new Object[]{};
            }
            objectArray2[4] = objectArray;
            objectArray2[5] = "permission_overwrites";
            objectArray2[6] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray2).executeAs(node -> (ChannelCategory)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toChannelCategory().orElseThrow(AssertionError::new));
        }
    }

    public static abstract class ServerChannelBuilder<T, R>
    extends ChannelBuilder<T, R>
    implements ServerChannel.Builder<T, R> {
        protected final ChannelType type;
        protected Server server;
        protected String name;
        protected ChannelCategory category;
        protected List<PermissionOverride> overrides;

        protected ServerChannelBuilder(Discord discord, ChannelType type) {
            super(discord);
            this.type = type;
            this.overrides = new ArrayList<PermissionOverride>();
        }

        public T setServer(Server server) {
            this.server = server;
            return (T)this.superType;
        }

        public T setName(String name) {
            this.name = name;
            return (T)this.superType;
        }

        public T setCategory(ChannelCategory category) {
            this.category = category;
            return (T)this.superType;
        }

        public T addPermissionOverride(PermissionOverride override) {
            this.overrides.add(override);
            return (T)this.superType;
        }

        public JsonNode toPartialJsonNode() {
            if (this.name == null) {
                throw new IllegalArgumentException("No channel name set!");
            }
            return JsonHelper.objectNode((Object[])new Object[]{"name", this.name, "type", this.type.getId()});
        }
    }

    public static abstract class ChannelBuilder<T, R>
    implements Channel.Builder<T, R> {
        protected final Discord discord;
        protected T superType;

        protected ChannelBuilder(Discord discord) {
            this.discord = discord;
        }

        public Discord getDiscord() {
            return this.discord;
        }

        protected void setSuperType(T superType) {
            this.superType = superType;
        }
    }

    public static class ChannelInviteBuilder
    implements ServerChannel.InviteBuilder {
        private final ServerChannel channel;
        private int maxAge = 0;
        private int maxUses = 0;
        private boolean temporary = false;
        private boolean unique = false;

        public ChannelInviteBuilder(ServerChannel channel) {
            this.channel = channel;
        }

        public ServerChannel.InviteBuilder setMaxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public ServerChannel.InviteBuilder setMaxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public ServerChannel.InviteBuilder setTemporaryMembership(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public ServerChannel.InviteBuilder setUnique(boolean unique) {
            this.unique = unique;
            return this;
        }

        public CompletableFuture<Invite> build() {
            return CoreInjector.webRequest(Invite.class, (Discord)this.channel.getDiscord()).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.CHANNEL_INVITE.createUri(new Object[]{this.channel})).setNode(new Object[]{"max_age", this.maxAge, "max_uses", this.maxUses, "temporary", this.temporary, "unique", this.unique}).executeAs(node -> new InviteInternal(this.channel.getDiscord(), (JsonNode)node));
        }
    }
}

