/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.handling.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.event.message.generic.MessageDeleteEventInternal;
import de.kaleidox.crystalshard.internal.handling.handlers.HandlerBase;
import de.kaleidox.crystalshard.internal.util.RoleContainer;
import de.kaleidox.crystalshard.main.handling.event.message.generic.MessageDeleteEvent;
import de.kaleidox.crystalshard.main.handling.listener.ListenerAttachable;
import de.kaleidox.crystalshard.main.handling.listener.message.generic.MessageDeleteListener;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.TextChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.markers.IDPair;
import java.util.Collections;
import java.util.List;

public class MESSAGE_DELETE
extends HandlerBase {
    @Override
    public void handle(DiscordInternal discord, JsonNode data) {
        long serverId = data.path("guild_id").asLong(-1L);
        long channelId = data.get("channel_id").asLong();
        long messageId = data.get("id").asLong();
        TextChannel channel = (TextChannel)((Channel)discord.getChannelCache().getOrRequest((Object)channelId, (Object)channelId)).toTextChannel().orElseThrow(AssertionError::new);
        Message message = (Message)discord.getMessageCache().getOrRequest((Object)messageId, (Object)IDPair.of((long)channelId, (long)messageId));
        Server server = serverId != -1L ? (Server)discord.getServerCache().getOrRequest((Object)serverId, (Object)serverId) : null;
        User user = message.getAuthorAsUser().orElse(null);
        List<Role> roles = user != null ? user.getRoles(server) : Collections.emptyList();
        MessageDeleteEventInternal event = new MessageDeleteEventInternal(discord, message);
        MESSAGE_DELETE.collectListeners(MessageDeleteListener.class, (ListenerAttachable[])new ListenerAttachable[]{discord, server, channel, new RoleContainer(roles), user, message}).forEach(listener -> discord.getThreadPool().execute(() -> listener.onMessageDelete((MessageDeleteEvent)event), new String[0]));
        message.detachAllListeners();
    }
}

