/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.handling.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.util.RoleContainer;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.ListenerAttachable;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.server.role.RoleAttachableListener;
import de.kaleidox.crystalshard.main.items.role.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class HandlerBase {
    private static final Package handlerPackage = HandlerBase.class.getPackage();
    private static final ConcurrentHashMap<String, HandlerBase> instances = new ConcurrentHashMap();
    static final Logger baseLogger = new Logger(HandlerBase.class);

    public abstract void handle(DiscordInternal var1, JsonNode var2);

    public static <T extends HandlerBase> void tryHandle(DiscordInternal discord, JsonNode data) {
        String type = data.path("t").asText("");
        if (instances.containsKey(type)) {
            instances.get(type).handle(discord, data.get("d"));
        } else if (!type.isEmpty()) {
            try {
                Class<?> tClass = Class.forName(handlerPackage.getName() + "." + type);
                HandlerBase handler = (HandlerBase)tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                instances.put(type, handler);
                try {
                    baseLogger.trace((Object)("Dispatching event '" + data.get("t").asText() + "' with body: " + data.get("d").toString()));
                    handler.handle(discord, data.get("d"));
                }
                catch (Exception e) {
                    baseLogger.exception((Throwable)e, "Exception in Handler: " + type);
                }
            }
            catch (ClassNotFoundException e) {
                baseLogger.error((Object)("Failed to dispatch unknown type: " + data.get("t")));
            }
            catch (Exception e) {
                baseLogger.exception((Throwable)e, "Failed to create instance of handler: " + data.get("t"));
            }
        }
    }

    @SafeVarargs
    static <L extends Listener, C extends ListenerAttachable<? super L>> List<L> collectListeners(@NotNull Class<L> listenerClass, C ... collectIn) {
        Objects.requireNonNull(listenerClass);
        ArrayList collect = new ArrayList();
        for (C item : collectIn) {
            if (!Objects.nonNull(item)) continue;
            if (item instanceof RoleContainer) {
                for (Role role : ((RoleContainer)item).getRoles()) {
                    role.getListenerManagers().stream().filter(manager -> listenerClass.isAssignableFrom(((RoleAttachableListener)manager.getListener()).getClass())).filter(ListenerManager::isEnabled).map(ListenerManager::getListener).map(listener -> listener).forEachOrdered(collect::add);
                }
                continue;
            }
            item.getListenerManagers().stream().filter(manager -> listenerClass.isAssignableFrom(manager.getListener().getClass())).filter(ListenerManager::isEnabled).map(ListenerManager::getListener).map(listener -> listener).forEachOrdered(collect::add);
        }
        return collect;
    }
}

