/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user.presence;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.main.items.user.presence.UserActivity;
import de.kaleidox.util.helpers.UrlHelper;
import de.kaleidox.util.markers.BiTimestamp;
import java.net.URL;
import java.util.Optional;

public class UserActivityInternal
implements UserActivity {
    private final String name;
    private final UserActivity.Type type;
    private final URL streamUrl;
    private final BiTimestamp timestamps;
    private final long applicationId;
    private final String details;
    private final String state;
    private final UserActivity.Party party;
    private final UserActivity.Assets assets;
    private final UserActivity.Secrets secrets;
    private final boolean instance;
    private final UserActivity.Flag flags;

    public UserActivityInternal(JsonNode data) {
        this.name = data.get("name").asText();
        this.type = UserActivity.Type.getFromId((int)data.get("type").asInt(-1));
        this.streamUrl = UrlHelper.orNull((String)data.path("url").asText(null));
        this.timestamps = data.has("timestamps") ? new BiTimestamp(data.get("timestamps")) : null;
        this.applicationId = data.path("application_id").asLong(-1L);
        this.details = data.path("details").asText(null);
        this.state = data.path("state").asText(null);
        this.party = data.has("party") ? new Party(data.get("party")) : null;
        this.assets = data.has("assets") ? new Assets(data.get("assets")) : null;
        this.secrets = data.has("secrets") ? new Secrets(data.get("secrets")) : null;
        this.instance = data.path("instance").asBoolean(false);
        this.flags = UserActivity.Flag.getFromValue((int)data.path("flags").asInt(-1));
    }

    public UserActivity.Type getType() {
        return this.type;
    }

    public Optional<URL> getStreamUrl() {
        return Optional.ofNullable(this.streamUrl);
    }

    public Optional<BiTimestamp> getBiTimestamp() {
        return Optional.ofNullable(this.timestamps);
    }

    public Optional<Long> getApplicationId() {
        return this.applicationId == -1L ? Optional.empty() : Optional.of(this.applicationId);
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this.details);
    }

    public Optional<String> getPartyStatus() {
        return Optional.ofNullable(this.state);
    }

    public Optional<UserActivity.Party> getParty() {
        return Optional.ofNullable(this.party);
    }

    public Optional<UserActivity.Assets> getAssets() {
        return Optional.ofNullable(this.assets);
    }

    public Optional<UserActivity.Secrets> getSecrets() {
        return Optional.ofNullable(this.secrets);
    }

    public boolean isInstanced() {
        return this.instance;
    }

    public Optional<UserActivity.Flag> getFlag() {
        return Optional.ofNullable(this.flags);
    }

    public String getName() {
        return this.name;
    }

    public class Assets
    implements UserActivity.Assets {
        private final String largeImage;
        private final String largeHover;
        private final String smallImage;
        private final String smallHover;

        public Assets(JsonNode data) {
            this.largeImage = data.path("large_image").asText(null);
            this.largeHover = data.path("large_text").asText(null);
            this.smallImage = data.path("small_image").asText(null);
            this.smallHover = data.path("small_text").asText(null);
        }

        public Optional<String> getLargeImage() {
            return Optional.ofNullable(this.largeImage);
        }

        public Optional<String> getLargeImageHoverText() {
            return Optional.ofNullable(this.largeHover);
        }

        public Optional<String> getSmallImage() {
            return Optional.ofNullable(this.smallImage);
        }

        public Optional<String> getSmallImageHoverText() {
            return Optional.ofNullable(this.smallHover);
        }
    }

    public class Party
    implements UserActivity.Party {
        private final long id;
        private final int currentSize;
        private final int maxSize;

        public Party(JsonNode data) {
            this.id = data.path("id").asLong(-1L);
            this.currentSize = data.path("size").path(0).asInt(-1);
            this.maxSize = data.path("size").path(1).asInt(-1);
        }

        public Optional<Long> getId() {
            return this.id == -1L ? Optional.empty() : Optional.of(this.id);
        }

        public Optional<Integer> getCurrentSize() {
            return this.currentSize == -1 ? Optional.empty() : Optional.of(this.currentSize);
        }

        public Optional<Integer> getMaxSize() {
            return this.maxSize == -1 ? Optional.empty() : Optional.of(this.maxSize);
        }
    }

    public class Secrets
    implements UserActivity.Secrets {
        private final String join;
        private final String spectate;
        private final String match;

        public Secrets(JsonNode data) {
            this.join = data.path("join").asText(null);
            this.spectate = data.path("spectate").asText(null);
            this.match = data.path("match").asText(null);
        }

        public Optional<String> getJoinSecret() {
            return Optional.ofNullable(this.join);
        }

        public Optional<String> getSpectateSecret() {
            return Optional.ofNullable(this.spectate);
        }

        public Optional<String> getMatchSecret() {
            return Optional.ofNullable(this.match);
        }
    }
}

