/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.user;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.internal.items.user.ServerMemberInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.UserEditTrait;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.user.UserAttachableListener;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.PrivateTextChannel;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.helpers.JsonHelper;
import de.kaleidox.util.helpers.NullHelper;
import de.kaleidox.util.helpers.UrlHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class UserInternal
implements User {
    private static final Logger logger = new Logger(User.class);
    private static final ConcurrentHashMap<Long, User> instances = new ConcurrentHashMap();
    private final long id;
    private final boolean bot;
    private final Discord discord;
    private final List<ListenerManager<? extends UserAttachableListener>> listenerManagers;
    private String name;
    private URL avatarUrl;
    private boolean mfa;
    private boolean verified;
    private String locale;
    private String email;
    String discriminator;

    UserInternal(User user) {
        this.id = user.getId();
        this.name = user.getName();
        this.discriminator = user.getDiscriminator();
        this.avatarUrl = user.getAvatarUrl().orElse(null);
        this.bot = user.isBot();
        this.mfa = user.hasMultiFactorAuthorization();
        this.verified = user.isVerified();
        this.locale = user.getLocale().orElse(null);
        this.email = user.getEmail().orElse(null);
        this.discord = user.getDiscord();
        this.listenerManagers = ((UserInternal)user).listenerManagers;
    }

    public UserInternal(Discord discord, JsonNode data) {
        logger.deeptrace((Object)("Creating user object for data: " + data.toString()));
        this.discord = discord;
        this.id = data.get("id").asLong();
        this.name = data.path("username").asText(null);
        this.discriminator = data.get("discriminator").asText();
        this.avatarUrl = data.has("avatar_url") ? UrlHelper.orNull((String)data.get("avatar_url").asText()) : null;
        this.bot = data.path("bot").asBoolean(false);
        this.mfa = data.has("mfa") ? data.get("mfa_enabled").asBoolean(false) : false;
        this.locale = data.has("locale") ? data.get("locale").asText(null) : null;
        this.verified = data.has("verified") ? data.get("verified").asBoolean(false) : false;
        this.email = data.has("email") ? data.get("email").asText(null) : null;
        this.listenerManagers = new ArrayList<ListenerManager<? extends UserAttachableListener>>();
        NullHelper.requireNonNull((Object[])new Object[]{this.name, this.discriminator});
        instances.putIfAbsent(this.id, this);
    }

    public String getDiscriminatedName() {
        return this.name + "#" + this.discriminator;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public Optional<String> getNickname(Server inServer) {
        return null;
    }

    public String getDisplayName(Server inServer) {
        if (inServer == null) {
            return this.getName();
        }
        return this.getNickname(inServer).orElseGet(this::getName);
    }

    public String getNicknameMentionTag() {
        return "<@!" + this.id + ">";
    }

    public Optional<URL> getAvatarUrl() {
        return Optional.ofNullable(this.avatarUrl);
    }

    public boolean isBot() {
        return this.bot;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public boolean hasMultiFactorAuthorization() {
        return this.mfa;
    }

    public boolean isYourself() {
        return this.equals((DiscordItem)this.discord.getSelf());
    }

    public Optional<String> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    public ServerMember toServerMember(Server server, JsonNode data) {
        if (this instanceof ServerMember) {
            return (ServerMember)this;
        }
        return ServerMemberInternal.getInstance(this, server, data);
    }

    public Collection<Role> getRoles(Server server) {
        return Collections.emptyList();
    }

    public CompletableFuture<PrivateTextChannel> openPrivateChannel() {
        return CoreInjector.webRequest(PrivateTextChannel.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.SELF_CHANNELS.createUri(new Object[0])).setNode((JsonNode)JsonHelper.objectNode((Object[])new Object[]{"recipient_id", this.id})).executeAs(node -> (PrivateTextChannel)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toPrivateTextChannel().orElseThrow(AssertionError::new));
    }

    public Optional<ServerMember> toServerMember(Server server) {
        return server.getMembers().stream().filter(usr -> usr.getId() == this.id).findAny();
    }

    public String getName() {
        return this.name;
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public String getMentionTag() {
        return "<@" + this.id + ">";
    }

    public String toString() {
        return "User with ID [" + this.id + "]";
    }

    public <C extends UserAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance((DiscordInternal)this.discord, listener);
        this.listenerManagers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(UserAttachableListener listener) {
        return null;
    }

    public Collection<ListenerManager<? extends UserAttachableListener>> getListenerManagers() {
        return this.listenerManagers;
    }

    public Collection<UserAttachableListener> getAttachedListeners() {
        return null;
    }

    public Cache<User, Long, Long> getCache() {
        return this.discord.getUserCache();
    }

    public Set<EditTrait<User>> updateData(JsonNode data) {
        HashSet<EditTrait<User>> traits = new HashSet<EditTrait<User>>();
        if (!this.name.equals(data.path("name").asText(this.name))) {
            this.name = data.get("name").asText();
            traits.add((EditTrait<User>)UserEditTrait.USERNAME);
        }
        if (!this.discriminator.equals(data.path("discriminator").asText(this.discriminator))) {
            this.discriminator = data.get("discriminator").asText();
            traits.add((EditTrait<User>)UserEditTrait.DISCRIMINATOR);
        }
        if (!((String)NullHelper.orDefault((Object)this.locale, (Object)"")).equals(data.path("avatar_url").asText((String)NullHelper.orDefault((Object)this.locale, (Object)"")))) {
            this.avatarUrl = UrlHelper.orNull((String)data.get("avatar_url").asText());
            traits.add((EditTrait<User>)UserEditTrait.AVATAR);
        }
        if (this.mfa != data.path("mfa_enabled").asBoolean(this.mfa)) {
            this.mfa = data.get("mfa_enabled").asBoolean();
            traits.add((EditTrait<User>)UserEditTrait.MFA_STATE);
        }
        if (this.verified != data.path("verified").asBoolean(this.verified)) {
            this.verified = data.get("verified").asBoolean();
            traits.add((EditTrait<User>)UserEditTrait.VERIFIED_STATE);
        }
        if (!((String)NullHelper.orDefault((Object)this.locale, (Object)"")).equals(data.path("locale").asText((String)NullHelper.orDefault((Object)this.locale, (Object)"")))) {
            this.locale = data.get("locale").asText();
            traits.add((EditTrait<User>)UserEditTrait.LOCALE);
        }
        if (!((String)NullHelper.orDefault((Object)this.email, (Object)"")).equals(data.path("email").asText((String)NullHelper.orDefault((Object)this.email, (Object)"")))) {
            this.email = data.get("email").asText();
            traits.add((EditTrait<User>)UserEditTrait.EMAIL);
        }
        return traits;
    }
}

