/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server.interactive;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.interactive.Invite;
import de.kaleidox.crystalshard.main.items.server.interactive.MetaInvite;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.UrlHelper;
import java.net.URL;
import java.time.Instant;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;

public class InviteInternal
implements Invite {
    private final Discord discord;
    private final String code;
    private final Server guild;
    private final ServerChannel channel;
    private final int approxPresenceCount;
    private final int approxOnlineCount;

    public InviteInternal(Discord discord, JsonNode data) {
        this.discord = discord;
        this.code = data.get("code").asText();
        this.guild = data.has("guild") ? (Server)discord.getServerCache().getOrRequest((Object)data.get("guild").get("id").asLong(), (Object)data.get("guild").get("id").asLong()) : null;
        this.channel = (ServerChannel)((Channel)discord.getChannelCache().getOrRequest((Object)data.get("channel").get("id").asLong(), (Object)data.get("channel").get("id").asLong())).toServerChannel().orElseThrow(AssertionError::new);
        this.approxPresenceCount = data.path("approximate_presence_count").asInt(-1);
        this.approxOnlineCount = data.path("approximate_online_count").asInt(-1);
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public String getInviteCode() {
        return this.code;
    }

    public Optional<Server> getServer() {
        return Optional.ofNullable(this.guild);
    }

    public ServerChannel getChannel() {
        return this.channel;
    }

    public int getApproximateOnlineCount() {
        return this.approxOnlineCount;
    }

    public int getApproximateMemberCount() {
        return this.approxPresenceCount;
    }

    public URL getUrl() {
        return UrlHelper.require((String)this.toString());
    }

    public CompletableFuture<Void> delete() {
        if (!this.channel.hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot delete invite.", new Permission[]{Permission.MANAGE_CHANNELS}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.INVITE.createUri(new Object[]{this.code})).executeAsVoid();
    }

    public String toString() {
        return "https://discord.gg/" + this.code;
    }

    public static class Meta
    extends InviteInternal
    implements MetaInvite {
        private final User inviter;
        private final int uses;
        private final int maxUses;
        private final int maxAge;
        private final boolean temporary;
        private final Instant createdAt;
        private final boolean revoked;

        public Meta(Discord discord, JsonNode data) {
            super(discord, data);
            this.inviter = (User)discord.getUserCache().getOrRequest((Object)data.get("user").get("id").asLong(), (Object)data.get("user").get("id").asLong());
            this.uses = data.get("uses").asInt();
            this.maxUses = data.get("max_uses").asInt();
            this.maxAge = data.get("max_age").asInt();
            this.temporary = data.get("temporary").asBoolean();
            this.createdAt = Instant.parse(data.get("created_at").asText());
            this.revoked = data.get("revoked").asBoolean();
        }

        public User getInviter() {
            return this.inviter;
        }

        public int getUses() {
            return this.uses;
        }

        public OptionalInt getMaxUses() {
            return this.maxUses == 0 ? OptionalInt.empty() : OptionalInt.of(this.maxUses);
        }

        public Instant expiresAt() {
            return this.createdAt.plusSeconds(this.maxAge);
        }

        public boolean temporaryMembership() {
            return this.temporary;
        }

        public Instant createdAt() {
            return this.createdAt;
        }

        public boolean isRevoked() {
            return this.revoked;
        }
    }
}

