/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server.interactive;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.interactive.Integration;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.markers.IDPair;
import java.time.Instant;

public class IntegrationInternal
implements Integration {
    private final Discord discord;
    private final Server server;
    private final long id;
    private final String name;
    private final String type;
    private final boolean enabled;
    private final boolean syncing;
    private final long roleId;
    private final Role role;
    private final int expireBehaviour;
    private final int expireGracePeriod;
    private final User user;
    private final Account account;
    private final Instant syncedAt;

    public IntegrationInternal(Discord discord, Server server, JsonNode data) {
        this.discord = discord;
        this.server = server;
        this.id = data.get("id").asLong();
        this.name = data.get("name").asText();
        this.type = data.get("type").asText();
        this.enabled = data.get("enabled").asBoolean();
        this.syncing = data.get("syncing").asBoolean();
        this.roleId = data.get("role_id").asLong();
        this.role = (Role)discord.getRoleCache().getOrRequest((Object)this.roleId, (Object)IDPair.of((long)server.getId(), (long)this.roleId));
        this.expireBehaviour = data.get("expire_behaviour").asInt();
        this.expireGracePeriod = data.get("expire_grace_period").asInt();
        this.user = (User)discord.getUserCache().getOrCreate(new Object[]{discord, data.get("user")});
        this.account = new Account(data.get("account"));
        this.syncedAt = Instant.parse(data.get("synced_at").asText());
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSyncing() {
        return this.syncing;
    }

    public Role getSubscribersRole() {
        return this.role;
    }

    public int expireBehaviour() {
        return this.expireBehaviour;
    }

    public int expireGracePeriod() {
        return this.expireGracePeriod;
    }

    public User getUser() {
        return this.user;
    }

    public Account getAccount() {
        return this.account;
    }

    public Instant syncedAt() {
        return this.syncedAt;
    }

    public Server getServer() {
        return this.server;
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public class Account
    implements Integration.Account {
        private final String id;
        private final String name;

        private Account(JsonNode data) {
            this.id = data.get("id").asText();
            this.name = data.get("name").asText();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

