/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server.emoji;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.InternalInjector;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.server.emoji.UnicodeEmoji;

public class UnicodeEmojiInternal
implements UnicodeEmoji {
    private static final Logger logger = new Logger(UnicodeEmojiInternal.class);
    private final DiscordInternal discord;
    private final String emojiExact;
    private final String aliases;

    public UnicodeEmojiInternal(Discord discord, JsonNode data, boolean partialData) {
        logger.deeptrace((Object)("Creating UnicodeEmoji object for data: " + data));
        this.discord = (DiscordInternal)discord;
        this.emojiExact = data.get("name").asText();
        this.aliases = InternalInjector.parseToAliases((String)this.emojiExact);
    }

    public UnicodeEmojiInternal(Discord discord, String aliases, String unicode) {
        logger.deeptrace((Object)("Creating UnicodeEmoji object [" + unicode + "] and aliases: [" + aliases + "]"));
        this.discord = (DiscordInternal)discord;
        this.emojiExact = unicode;
        this.aliases = aliases;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnicodeEmoji) {
            return ((UnicodeEmoji)obj).toDiscordPrintable().equalsIgnoreCase(this.toDiscordPrintable());
        }
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.toDiscordPrintable());
        }
        return false;
    }

    public String toString() {
        return this.emojiExact;
    }

    public String toDiscordPrintable() {
        return this.emojiExact;
    }

    public String toAlias() {
        return this.aliases;
    }

    public Discord getDiscord() {
        return null;
    }

    public String getMentionTag() {
        return this.toDiscordPrintable();
    }
}

