/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.VoiceStateEditTrait;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.VoiceChannel;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.VoiceState;
import de.kaleidox.crystalshard.main.items.user.User;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class VoiceStateInternal
implements VoiceState {
    private static final ConcurrentHashMap<String, VoiceStateInternal> instances = new ConcurrentHashMap();
    private final Discord discord;
    private final Server server;
    private final User user;
    private final String sessionId;
    private VoiceChannel channel;
    private boolean deafened;
    private boolean muted;
    private boolean selfMuted;
    private boolean selfDeafened;
    private boolean suppressed;

    private VoiceStateInternal(Discord discord, JsonNode data) {
        this.discord = discord;
        long serverId = data.get("guild_id").asLong(-1L);
        this.server = serverId == -1L ? null : (Server)discord.getServerCache().getOrRequest((Object)serverId, (Object)serverId);
        long userId = data.get("user_id").asLong();
        this.user = (User)discord.getUserCache().getOrRequest((Object)userId, (Object)userId);
        this.sessionId = data.get("session_id").asText();
        this.updateData(data);
        instances.entrySet().stream().filter(entry -> ((VoiceStateInternal)entry.getValue()).getUser().equals((DiscordItem)this.user)).forEach(entry -> instances.remove(entry.getKey(), entry.getValue()));
        instances.put(this.sessionId, this);
    }

    public Set<EditTrait<VoiceState>> updateData(JsonNode data) {
        HashSet<EditTrait<VoiceState>> traits = new HashSet<EditTrait<VoiceState>>();
        long channelId = data.path("channel_id").asLong(this.channel.getId());
        VoiceChannel newChannel = (VoiceChannel)((Channel)this.discord.getChannelCache().getOrRequest((Object)channelId, (Object)channelId)).toVoiceChannel().orElseThrow(AssertionError::new);
        if (!this.channel.equals((DiscordItem)newChannel)) {
            this.channel = newChannel;
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.CHANNEL);
        }
        if (this.deafened != data.path("deaf").asBoolean(this.deafened)) {
            this.deafened = data.get("deaf").asBoolean();
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.DEAFENED_STATE);
        }
        if (this.muted != data.path("mute").asBoolean(this.muted)) {
            this.muted = data.get("mute").asBoolean();
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.MUTED_STATE);
        }
        if (this.selfDeafened != data.path("self_deaf").asBoolean(this.selfDeafened)) {
            this.selfDeafened = data.get("self_deaf").asBoolean();
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.SELF_DEAFENED_STATE);
        }
        if (this.selfMuted != data.get("self_mute").asBoolean(this.selfMuted)) {
            this.selfMuted = data.get("self_mute").asBoolean();
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.SELF_MUTED_STATE);
        }
        if (this.suppressed != data.get("suppress").asBoolean(this.suppressed)) {
            this.suppressed = data.get("suppress").asBoolean();
            traits.add((EditTrait<VoiceState>)VoiceStateEditTrait.SUPPRESSED_STATE);
        }
        return traits;
    }

    public Discord getDiscord() {
        return null;
    }

    public Optional<Server> getServer() {
        return Optional.empty();
    }

    public VoiceChannel getChannel() {
        return null;
    }

    public User getUser() {
        return null;
    }

    public boolean isDeafened() {
        return false;
    }

    public boolean isMuted() {
        return false;
    }

    public boolean isSelfDeafened() {
        return false;
    }

    public boolean isSelfMuted() {
        return false;
    }

    public boolean isSuppressed() {
        return false;
    }

    public static VoiceState getInstance(Discord discord, JsonNode data) {
        return instances.getOrDefault(data.get("session_id").asText(), new VoiceStateInternal(discord, data));
    }
}

