/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.server;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.internal.items.channel.ChannelStructureInternal;
import de.kaleidox.crystalshard.internal.items.permission.PermissionListInternal;
import de.kaleidox.crystalshard.internal.items.server.VoiceStateInternal;
import de.kaleidox.crystalshard.internal.items.server.interactive.IntegrationInternal;
import de.kaleidox.crystalshard.internal.items.server.interactive.ServerMemberUpdater;
import de.kaleidox.crystalshard.internal.items.user.ServerMemberInternal;
import de.kaleidox.crystalshard.internal.items.user.presence.PresenceInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.ServerEditTrait;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.server.ServerAttachableListener;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelStructure;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerVoiceChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionList;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.DefaultMessageNotificationLevel;
import de.kaleidox.crystalshard.main.items.server.ExplicitContentFilterLevel;
import de.kaleidox.crystalshard.main.items.server.MFALevel;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.VerificationLevel;
import de.kaleidox.crystalshard.main.items.server.VoiceRegion;
import de.kaleidox.crystalshard.main.items.server.VoiceState;
import de.kaleidox.crystalshard.main.items.server.emoji.CustomEmoji;
import de.kaleidox.crystalshard.main.items.server.interactive.Integration;
import de.kaleidox.crystalshard.main.items.user.ServerMember;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.main.items.user.presence.Presence;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.UrlHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ServerInternal
implements Server {
    private static final ConcurrentHashMap<Long, ServerInternal> instances = new ConcurrentHashMap();
    private static final Logger logger = new Logger(ServerInternal.class);
    private final DiscordInternal discord;
    private final long id;
    private final ArrayList<Role> roles = new ArrayList();
    private final ArrayList<CustomEmoji> emojis = new ArrayList();
    private final ArrayList<String> features = new ArrayList();
    private final ArrayList<VoiceState> voiceStates = new ArrayList();
    private final ArrayList<ServerMember> members = new ArrayList();
    private final ArrayList<ServerChannel> channels = new ArrayList();
    private final ArrayList<Presence> presenceStates = new ArrayList();
    private final List<ListenerManager<? extends ServerAttachableListener>> listenerManangers;
    private Role everyoneRole;
    private String name;
    private URL iconUrl;
    private URL splashUrl;
    private User owner;
    private PermissionList ownPermissions;
    private VoiceRegion voiceRegion;
    private ServerVoiceChannel afkChannel;
    private int afkTimeout;
    private boolean embedEnabled;
    private ServerChannel embedChannel;
    private VerificationLevel verificationLevel;
    private DefaultMessageNotificationLevel defaultMessageNotificationLevel;
    private ExplicitContentFilterLevel explicitContentFilterLevel;
    private MFALevel mfaLevel;
    private boolean widgetEnabled;
    private ServerChannel widgetChannel;
    private ServerTextChannel systemChannel;
    private boolean large;
    private boolean unavailable;
    private int memberCount;
    private ChannelStructureInternal structure;

    public ServerInternal(Discord discord, JsonNode data) {
        logger.deeptrace((Object)("Creating server object for data: " + data.toString()));
        this.discord = (DiscordInternal)discord;
        this.id = data.get("id").asLong();
        if (data.has("unavailable") && data.get("unavailable").asBoolean()) {
            this.unavailable = true;
        } else {
            data.path("roles").forEach(role -> this.roles.add((Role)discord.getRoleCache().getOrCreate(new Object[]{discord, this, role})));
            data.path("emojis").forEach(emoji -> this.emojis.add((CustomEmoji)discord.getEmojiCache().getOrCreate(new Object[]{this.getDiscord(), this, emoji, true})));
            data.path("features").forEach(feature -> this.features.add(feature.asText()));
            data.path("voice_states").forEach(state -> this.voiceStates.add(VoiceStateInternal.getInstance(discord, state)));
            data.path("members").forEach(member -> this.members.add(((User)discord.getUserCache().getOrCreate(new Object[]{discord, member.get("user")})).toServerMember((Server)this, member)));
            data.path("channels").forEach(channel -> this.channels.add((ServerChannel)((Channel)discord.getChannelCache().getOrCreate(new Object[]{discord, this, channel})).toServerChannel().orElseThrow(AssertionError::new)));
            data.path("presenceStates").forEach(presence -> this.presenceStates.add(PresenceInternal.getInstance(discord, presence)));
            this.structure = new ChannelStructureInternal(this.channels);
            this.updateData(data);
            this.everyoneRole = this.roles.stream().filter(role -> role.getName().equalsIgnoreCase("@everyone")).findAny().orElseThrow(() -> new NoSuchElementException("No @everyone Role found!"));
        }
        this.listenerManangers = new ArrayList<ListenerManager<? extends ServerAttachableListener>>();
        instances.put(this.id, this);
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public Set<EditTrait<Server>> updateData(JsonNode data) {
        HashSet<EditTrait<Server>> traits = new HashSet<EditTrait<Server>>();
        if (this.name == null || !this.name.equals(data.path("name").asText(""))) {
            this.name = data.get("name").asText();
            traits.add((EditTrait<Server>)ServerEditTrait.NAME);
        }
        if (this.iconUrl != null && !UrlHelper.equals((Object)this.iconUrl, (Object)data.path("icon").asText(null))) {
            this.iconUrl = UrlHelper.orNull((String)data.path("icon").asText(null));
            traits.add((EditTrait<Server>)ServerEditTrait.ICON);
        }
        if (this.splashUrl != null && !UrlHelper.equals((Object)this.splashUrl, (Object)data.path("splash_url").asText(null))) {
            this.splashUrl = UrlHelper.ignoreIfNull((String)data.path("splashUrl").asText(null));
            traits.add((EditTrait<Server>)ServerEditTrait.SPLASH);
        }
        if ((this.ownPermissions != null ? this.ownPermissions.toPermissionInt() : 0) != data.path("permissions").asInt(0)) {
            this.ownPermissions = new PermissionListInternal(data.get("permissions").asInt(0));
            traits.add((EditTrait<Server>)ServerEditTrait.OWN_PERMISSIONS);
        }
        if (this.voiceRegion == null || !this.voiceRegion.getRegionKey().equalsIgnoreCase(data.path("region").asText(this.voiceRegion.getRegionKey()))) {
            this.voiceRegion = VoiceRegion.getFromRegionKey((String)data.path("region").asText(""));
            traits.add((EditTrait<Server>)ServerEditTrait.REGION);
        }
        if (this.afkTimeout != data.path("afk_timeout").asInt(-1)) {
            this.afkTimeout = data.get("afk_timeout").asInt(-1);
            traits.add((EditTrait<Server>)ServerEditTrait.AFK_TIMEOUT);
        }
        if (this.embedEnabled != data.path("embed_enabled").asBoolean(this.embedEnabled)) {
            this.embedEnabled = data.path("embed_enabled").asBoolean(false);
            traits.add((EditTrait<Server>)ServerEditTrait.EMBED_ENABLED);
        }
        if (this.verificationLevel == null || this.verificationLevel.getId() != data.path("verification_level").asInt(-1)) {
            this.verificationLevel = VerificationLevel.getFromId((int)data.get("verification_level").asInt(-1));
            traits.add((EditTrait<Server>)ServerEditTrait.VERIFICATION_LEVEL);
        }
        if (this.defaultMessageNotificationLevel == null || this.defaultMessageNotificationLevel.getId() != data.path("default_message_notification").asInt(this.defaultMessageNotificationLevel.getId())) {
            this.defaultMessageNotificationLevel = DefaultMessageNotificationLevel.getFromId((int)data.get("default_message_notifications").asInt(-1));
            traits.add((EditTrait<Server>)ServerEditTrait.DEFAULT_MESSAGE_NOTIFICATION_LEVEL);
        }
        if (this.explicitContentFilterLevel == null || this.explicitContentFilterLevel.getId() != data.path("explicit_content_filter").asInt(-1)) {
            this.explicitContentFilterLevel = ExplicitContentFilterLevel.getFromId((int)data.get("explicit_content_filter").asInt(-1));
            traits.add((EditTrait<Server>)ServerEditTrait.EXPLICIT_CONTENT_FILTER_LEVEL);
        }
        if (this.mfaLevel == null || this.mfaLevel.getId() != data.path("mfa_level").asInt(-1)) {
            this.mfaLevel = MFALevel.getFromId((int)data.get("mfa_level").asInt(-1));
            traits.add((EditTrait<Server>)ServerEditTrait.MFA_LEVEL);
        }
        if (this.widgetEnabled != data.path("widget_enabled").asBoolean(this.widgetEnabled)) {
            this.widgetEnabled = data.path("widget_enabled").asBoolean(false);
            traits.add((EditTrait<Server>)ServerEditTrait.WIDGET_ENABLED);
        }
        if (this.large != data.path("large").asBoolean(false)) {
            this.large = data.path("large").asBoolean(false);
            traits.add((EditTrait<Server>)ServerEditTrait.LARGE);
        }
        if (this.unavailable != data.path("unavailable").asBoolean(false)) {
            this.unavailable = data.path("unavailable").asBoolean(false);
            traits.add((EditTrait<Server>)ServerEditTrait.AVAILABILITY);
        }
        if (this.memberCount != data.path("member_count").asInt(this.memberCount)) {
            this.memberCount = data.path("member_count").asInt(-1);
            traits.add((EditTrait<Server>)ServerEditTrait.MEMBER_COUNT);
        }
        long afkChannelId = data.path("afk_channel_id").asLong(-1L);
        if (this.afkChannel == null || this.afkChannel.getId() != afkChannelId) {
            this.afkChannel = afkChannelId == -1L ? null : (ServerVoiceChannel)((Channel)this.discord.getChannelCache().getOrRequest((Object)afkChannelId, (Object)afkChannelId)).toServerVoiceChannel().orElseThrow(AssertionError::new);
            traits.add((EditTrait<Server>)ServerEditTrait.AFK_CHANNEL);
        }
        if (this.embedChannel == null || this.embedChannel.getId() != data.path("embed_channel_id").asLong(-1L)) {
            long embedChannelId = data.path("embed_channel_id").asLong(-1L);
            this.embedChannel = embedChannelId == -1L ? null : (ServerChannel)((Channel)this.discord.getChannelCache().getOrRequest((Object)embedChannelId, (Object)embedChannelId)).toServerChannel().orElseThrow(AssertionError::new);
            traits.add((EditTrait<Server>)ServerEditTrait.EMBED_CHANNEL);
        }
        if (this.widgetChannel == null || this.widgetChannel.getId() != data.path("widget_channel_id").asLong(-1L)) {
            long widgetChannelId = data.path("widget_channel_id").asLong(-1L);
            this.widgetChannel = widgetChannelId == -1L ? null : (ServerChannel)((Channel)this.discord.getChannelCache().getOrRequest((Object)widgetChannelId, (Object)widgetChannelId)).toServerChannel().orElseThrow(AssertionError::new);
            traits.add((EditTrait<Server>)ServerEditTrait.WIDGET_CHANNEL);
        }
        if (this.systemChannel == null || this.systemChannel.getId() != data.get("system_channel_id").asLong(-1L)) {
            long systemChannelId = data.path("system_channel_id").asLong(-1L);
            this.systemChannel = systemChannelId == -1L ? null : (ServerTextChannel)((Channel)this.discord.getChannelCache().getOrRequest((Object)systemChannelId, (Object)systemChannelId)).toServerTextChannel().orElseThrow(AssertionError::new);
            traits.add((EditTrait<Server>)ServerEditTrait.SYSTEM_CHANNEL);
        }
        if ((this.owner != null ? this.owner.getId() : -1L) != data.path(data.has("owner_id") ? "owner_id" : "application_id").asLong(-1L)) {
            if (!data.has("owner_id")) {
                return null;
            }
            long userId = data.get("owner_id").asLong();
            this.owner = (User)this.discord.getUserCache().getOrRequest((Object)userId, (Object)userId);
            traits.add((EditTrait<Server>)ServerEditTrait.OWNER);
        }
        return traits;
    }

    public Optional<URL> getIconUrl() {
        return Optional.ofNullable(this.iconUrl);
    }

    public Optional<URL> getSplashUrl() {
        return Optional.ofNullable(this.splashUrl);
    }

    public ServerMember getOwner() {
        return ServerMemberInternal.getInstance(this.owner, this);
    }

    public PermissionList getOwnPermissions() {
        return this.ownPermissions;
    }

    public VoiceRegion getVoiceRegion() {
        return this.voiceRegion;
    }

    public Optional<ServerVoiceChannel> getAfkChannel() {
        return Optional.ofNullable(this.afkChannel);
    }

    public int getAfkTimeout() {
        return this.afkTimeout;
    }

    public boolean isEmbeddable() {
        return this.embedEnabled;
    }

    public Optional<ServerChannel> getEmbedChannel() {
        return Optional.ofNullable(this.embedChannel);
    }

    public boolean isWidgetable() {
        return this.widgetEnabled;
    }

    public Optional<ServerChannel> getWidgetChannel() {
        return Optional.ofNullable(this.widgetChannel);
    }

    public Optional<ServerTextChannel> getSystemChannel() {
        return Optional.ofNullable(this.systemChannel);
    }

    public VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    public DefaultMessageNotificationLevel getDefaultMessageNotificationLevel() {
        return this.defaultMessageNotificationLevel;
    }

    public ExplicitContentFilterLevel getExplicitContentFilterLevel() {
        return this.explicitContentFilterLevel;
    }

    public List<Role> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<CustomEmoji> getCustomEmojis() {
        return Collections.unmodifiableList(this.emojis);
    }

    public List<String> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public MFALevel getMFALevel() {
        return this.mfaLevel;
    }

    public boolean isLarge() {
        return this.large;
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public Role getEveryoneRole() {
        return this.everyoneRole;
    }

    public List<VoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.voiceStates);
    }

    public List<ServerMember> getMembers() {
        return this.members.stream().map(user -> ServerMemberInternal.getInstance((User)user, this)).collect(Collectors.toList());
    }

    public List<ServerChannel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    public ChannelStructure getChannelStructure() {
        return this.structure;
    }

    public List<Presence> getPresenceStates() {
        return Collections.unmodifiableList(this.presenceStates);
    }

    public Optional<User> getUserById(long id) {
        return Optional.empty();
    }

    public CompletableFuture<Void> delete() {
        if (!this.getOwner().equals((DiscordItem)this.discord.getSelf())) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("You are not the owner of the guild!", new Permission[0]));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.SELF_GUILD.createUri(new Object[]{this})).executeAsVoid();
    }

    public CompletableFuture<Void> prune(int days) {
        if (days < 1 || days > 365) {
            throw new IllegalArgumentException("Parameter 'days' is not within its bounds! [1,365]");
        }
        if (!this.hasPermission(this.discord, Permission.KICK_MEMBERS)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot prune!", new Permission[]{Permission.KICK_MEMBERS}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD_PRUNE.createUri(new Object[]{this.id})).setNode(new Object[]{"days", days}).executeAsVoid();
    }

    public CompletableFuture<Collection<Integration>> requestIntegrations() {
        if (!this.hasPermission(this.discord, Permission.MANAGE_GUILD)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot get guild integrations!", new Permission[]{Permission.MANAGE_GUILD}));
        }
        WebRequest request = CoreInjector.webRequest((Discord)this.discord);
        return request.setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.GUILD_INTEGRATIONS.createUri(new Object[]{this.id})).executeAs(node -> {
            ArrayList<IntegrationInternal> list = new ArrayList<IntegrationInternal>();
            for (JsonNode data : node) {
                list.add(new IntegrationInternal(this.discord, this, data));
            }
            return list;
        });
    }

    public CompletableFuture<URL> getVanityUrl() {
        if (!this.hasPermission(this.discord, Permission.MANAGE_GUILD)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot get the vanity URL!", new Permission[]{Permission.MANAGE_GUILD}));
        }
        return CoreInjector.webRequest(URL.class, (Discord)this.discord).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.GUILD_VANITY_INVITE.createUri(new Object[]{this.id})).executeAs(node -> {
            if (!node.has("code")) {
                throw new NullPointerException("Guild does not have a vanity URL!");
            }
            try {
                return new URL("https://discord.gg/" + node.get("code").asText());
            }
            catch (MalformedURLException e) {
                throw new NullPointerException("Could not create URL: " + e);
            }
        });
    }

    public Optional<ServerMember> getServerMember(User ofUser) {
        return this.members.stream().filter(arg_0 -> ((User)ofUser).equals(arg_0)).map(ServerMember.class::cast).findAny();
    }

    public ServerMember.Updater getMemberUpdater(ServerMember member) {
        return new ServerMemberUpdater(member);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Server with ID [" + this.id + "]";
    }

    public <C extends ServerAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance(this.discord, listener);
        this.listenerManangers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(ServerAttachableListener listener) {
        ListenerManagerInternal<ServerAttachableListener> manager = ListenerManagerInternal.getInstance(this.discord, listener);
        return Evaluation.of((boolean)this.listenerManangers.remove(manager));
    }

    public Collection<ListenerManager<? extends ServerAttachableListener>> getListenerManagers() {
        return this.listenerManangers;
    }

    public Collection<ServerAttachableListener> getAttachedListeners() {
        return this.listenerManangers.stream().map(ListenerManager::getListener).collect(Collectors.toList());
    }

    public boolean hasPermission(User user, Permission permission) {
        return this.members.stream().filter(arg_0 -> ((User)user).equals(arg_0)).map(usr -> (ServerMember)usr.toServerMember().orElseThrow(AssertionError::new)).flatMap(member -> member.getRoles().stream()).sorted().map(Role::getPermissions).anyMatch(perm -> perm.contains((Object)permission));
    }

    public Cache<Server, Long, Long> getCache() {
        return this.discord.getServerCache();
    }

    private User getOwner(JsonNode data) {
        if (data.has("owner_id")) {
            long userId = data.get("owner_id").asLong();
            return (User)this.discord.getUserCache().getOrRequest((Object)userId, (Object)userId);
        }
        return null;
    }

    public List<ServerAttachableListener> getListeners() {
        return this.listenerManangers.stream().map(ListenerManager::getListener).collect(Collectors.toList());
    }

    public void replaceEmojis(List<CustomEmoji> newEmojis) {
        this.emojis.clear();
        this.emojis.addAll(newEmojis);
    }

    public void addUser(ServerMember user) {
        this.members.add(user);
    }

    public void removeUser(User user) {
        this.members.remove(user);
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public void removeRole(Role role) {
        this.roles.remove(role);
    }
}

