/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.role;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.internal.items.permission.PermissionListInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.RoleEditTrait;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.server.role.RoleAttachableListener;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionList;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.markers.IDPair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class RoleInternal
implements Role {
    private static final Logger logger = new Logger(RoleInternal.class);
    private static final ConcurrentHashMap<Long, Role> instances = new ConcurrentHashMap();
    private final Server server;
    private final long id;
    private final Discord discord;
    private PermissionList permissions;
    private String name;
    private Color color;
    private boolean grouping;
    private int position;
    private boolean managed;
    private boolean mentionable;
    private List<ListenerManager<? extends RoleAttachableListener>> listenerManangers;

    public RoleInternal(Discord discord, Server server, JsonNode data) {
        logger.deeptrace((Object)("Creating role object for data: " + data.toString()));
        this.discord = discord;
        this.server = server;
        this.id = data.get("id").asLong();
        this.name = data.get("name").asText();
        this.color = new Color(data.get("color").asInt());
        this.grouping = data.get("hoist").asBoolean();
        this.position = data.get("position").asInt();
        this.permissions = new PermissionListInternal(data.get("permissions").asInt());
        this.managed = data.get("managed").asBoolean();
        this.mentionable = data.get("mentionable").asBoolean();
        this.listenerManangers = new ArrayList<ListenerManager<? extends RoleAttachableListener>>();
        instances.putIfAbsent(this.id, this);
    }

    public Server getServer() {
        return this.server;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public boolean isMentionable() {
        return this.mentionable;
    }

    public int getPosition() {
        return this.position;
    }

    public PermissionList getPermissions() {
        return this.permissions;
    }

    public CompletableFuture<Void> delete() {
        if (!this.server.hasPermission(this.discord, Permission.MANAGE_ROLES)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot delete roles!", new Permission[]{Permission.MANAGE_ROLES}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.GUILD_ROLE_SPECIFIC.createUri(new Object[]{this.server, this.id})).executeAsVoid();
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public String getMentionTag() {
        return "<@&" + this.id + ">";
    }

    public String getName() {
        return this.name;
    }

    public <C extends RoleAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance((DiscordInternal)this.discord, listener);
        this.listenerManangers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(RoleAttachableListener listener) {
        return null;
    }

    public Collection<ListenerManager<? extends RoleAttachableListener>> getListenerManagers() {
        return this.listenerManangers;
    }

    public Collection<RoleAttachableListener> getAttachedListeners() {
        return null;
    }

    public int compareTo(Role o) {
        return this.getPosition() - o.getPosition();
    }

    public Cache<Role, Long, IDPair> getCache() {
        return this.discord.getRoleCache();
    }

    public Set<EditTrait<Role>> updateData(JsonNode data) {
        HashSet<EditTrait<Role>> traits = new HashSet<EditTrait<Role>>();
        if (this.permissions.toPermissionInt() != data.path("permissions").asInt(this.permissions.toPermissionInt())) {
            this.permissions = new PermissionListInternal(data.get("permissions").asInt());
            traits.add((EditTrait<Role>)RoleEditTrait.PERMISSION_OVERWRITES);
        }
        if (!this.name.equals(data.path("name").asText(this.name))) {
            this.name = data.get("name").asText();
            traits.add((EditTrait<Role>)RoleEditTrait.NAME);
        }
        if (!this.color.equals(new Color(data.path("color").asInt(this.color.getRGB())))) {
            this.color = new Color(data.get("color").asInt());
            traits.add((EditTrait<Role>)RoleEditTrait.COLOR);
        }
        if (this.grouping != data.path("hoist").asBoolean(this.grouping)) {
            this.grouping = data.get("hoist").asBoolean();
            traits.add((EditTrait<Role>)RoleEditTrait.GROUPING);
        }
        if (this.position != data.path("position").asInt(this.position)) {
            this.position = data.get("position").asInt();
            traits.add((EditTrait<Role>)RoleEditTrait.POSITION);
        }
        if (this.managed != data.path("managed").asBoolean(this.managed)) {
            this.managed = data.get("managed").asBoolean();
            traits.add((EditTrait<Role>)RoleEditTrait.MANAGED);
        }
        if (this.mentionable != data.path("mentionable").asBoolean(this.mentionable)) {
            this.mentionable = data.get("mentionable").asBoolean();
            traits.add((EditTrait<Role>)RoleEditTrait.MENTIONABILITY);
        }
        return traits;
    }
}

