/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.role;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.permission.PermissionOverrideInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.util.helpers.JsonHelper;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;

public class RoleBuilderInternal
implements Role.Builder {
    private final Discord discord;
    private final Server server;
    private String name;
    private PermissionOverrideInternal override;
    private Color color;
    private boolean hoist;
    private boolean mentionable;

    public RoleBuilderInternal(Discord discord, Server server) {
        this.discord = discord;
        this.server = server;
        this.name = "new role";
        this.override = (PermissionOverrideInternal)server.getEveryoneRole().getPermissions().toOverride();
        this.color = null;
        this.hoist = false;
        this.mentionable = false;
    }

    public Role.Builder setName(String name) {
        this.name = name;
        return this;
    }

    public Role.Builder setPermissions(PermissionOverride permissionOverride) {
        this.override = (PermissionOverrideInternal)permissionOverride;
        return this;
    }

    public Role.Builder setColor(Color color) {
        this.color = color;
        return this;
    }

    public Role.Builder setHoist(boolean hoist) {
        this.hoist = hoist;
        return this;
    }

    public Role.Builder setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public CompletableFuture<Role> build() {
        return CoreInjector.webRequest(Role.class, (Discord)this.discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.GUILD_ROLES.createUri(new Object[]{this.server})).setNode(this.toJsonNode()).executeAs(node -> (Role)this.discord.getRoleCache().getOrCreate(new Object[]{this.discord, this.server, node}));
    }

    public JsonNode toJsonNode() {
        return JsonHelper.objectNode((Object[])new Object[]{"name", this.name, "permissions", this.override.toPermissionInt(), "color", this.color == null ? 0 : this.color.getRGB(), "hoist", this.hoist, "mentionable", this.mentionable});
    }
}

