/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.permission;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.permission.PermissionListInternal;
import de.kaleidox.crystalshard.internal.items.user.ServerMemberInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.permission.OverrideState;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionList;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverwritable;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.JsonHelper;
import de.kaleidox.util.markers.IDPair;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PermissionOverrideInternal
extends ConcurrentHashMap<Permission, OverrideState>
implements PermissionOverride {
    private final Discord discord;
    private final Server server;
    private final PermissionOverride.Type type;
    private final PermissionOverwritable parent;

    public PermissionOverrideInternal(Discord discord, Server server, JsonNode data) {
        this.discord = discord;
        this.server = server;
        this.type = PermissionOverride.Type.getByKey((String)data.get("type").asText());
        switch (this.type) {
            default: {
                throw new AssertionError();
            }
            case ROLE: {
                long roleId = data.get("id").asLong();
                this.parent = (PermissionOverwritable)discord.getRoleCache().getOrRequest((Object)roleId, (Object)IDPair.of((long)server.getId(), (long)roleId));
                break;
            }
            case USER: {
                long userId = data.get("user_id").asLong();
                this.parent = ServerMemberInternal.getInstance((User)discord.getUserCache().getOrRequest((Object)userId, (Object)userId), server);
            }
        }
        new PermissionListInternal(data.get("allow").asInt(0)).forEach((? super T permission) -> this.put(permission, OverrideState.ALLOWED));
        new PermissionListInternal(data.get("deny").asInt(0)).forEach((? super T permission) -> this.put(permission, OverrideState.DENIED));
    }

    public PermissionOverrideInternal(Discord discord, Server server, PermissionOverwritable parent, PermissionList permissions) {
        this.discord = discord;
        this.server = server;
        this.parent = parent;
        this.type = parent instanceof User ? PermissionOverride.Type.USER : PermissionOverride.Type.ROLE;
        for (Permission perm : Permission.values()) {
            if (permissions.contains((Object)perm)) {
                this.put(perm, OverrideState.ALLOWED);
                continue;
            }
            this.put(perm, OverrideState.DENIED);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PermissionOverride)) {
            return false;
        }
        PermissionOverride other = (PermissionOverride)o;
        return this.getAllowed().toPermissionInt() == other.getAllowed().toPermissionInt() && this.getDenied().toPermissionInt() == other.getDenied().toPermissionInt();
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public Server getServer() {
        return this.server;
    }

    public PermissionOverride.Type getOverrideType() {
        return this.type;
    }

    public PermissionOverwritable getParent() {
        return this.parent;
    }

    public PermissionOverride addOverride(Permission permission, OverrideState state) {
        this.removeOverride(permission);
        this.put(permission, state);
        return this;
    }

    public PermissionOverride removeOverride(Permission permission) {
        this.remove(permission);
        return this;
    }

    public PermissionList getAllowed() {
        return this.entrySet().stream().filter(entry -> entry.getValue() == OverrideState.ALLOWED).map(Map.Entry::getKey).collect(Collectors.toCollection(() -> PermissionList.create((PermissionOverwritable)this.parent)));
    }

    public PermissionList getDenied() {
        return this.entrySet().stream().filter(entry -> entry.getValue() == OverrideState.DENIED).map(Map.Entry::getKey).collect(Collectors.toCollection(() -> PermissionList.create((PermissionOverwritable)this.parent)));
    }

    public int toPermissionInt() {
        int perm = Permission.EMBED_LINKS.getValue();
        for (Permission permission : this.getAllowed()) {
            permission.apply(perm, true);
        }
        return perm;
    }

    public JsonNode toJsonNode() {
        return JsonHelper.objectNode((Object[])new Object[]{"id", Long.toUnsignedString(Objects.requireNonNull(this.parent).getId()), "type", this.type.getKey(), "allow", this.getAllowed().toPermissionInt(), "deny", this.getDenied().toPermissionInt()});
    }
}

