/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message.embed;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.crystalshard.internal.util.Container;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.message.embed.SentEmbed;
import de.kaleidox.crystalshard.main.util.FileContainer;
import de.kaleidox.util.helpers.JsonHelper;
import de.kaleidox.util.helpers.UrlHelper;
import de.kaleidox.util.interfaces.JsonNodeable;
import java.awt.Color;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class EmbedDraftInternal
implements EmbedDraft,
JsonNodeable {
    private static final Logger logger = new Logger(EmbedDraftInternal.class);
    private final String title;
    private final String description;
    private final URL url;
    private final Instant timestamp;
    private final Color color;
    private final EmbedDraft.Footer footer;
    private final EmbedDraft.Image image;
    private final EmbedDraft.Thumbnail thumbnail;
    private final EmbedDraft.Author author;
    private final ArrayList<EmbedDraft.Field> fields;

    public EmbedDraftInternal(String title, String description, URL url, Instant timestamp, Color color, EmbedDraft.Footer footer, EmbedDraft.Image image, EmbedDraft.Thumbnail thumbnail, EmbedDraft.Author author, ArrayList<EmbedDraft.Field> fields) {
        this.title = title;
        this.description = description;
        this.url = url;
        this.timestamp = timestamp;
        this.color = color;
        this.footer = footer;
        this.image = image;
        this.thumbnail = thumbnail;
        this.author = author;
        this.fields = fields;
    }

    public EmbedDraft toEmbedDraft() {
        return this;
    }

    public Embed.Builder toBuilder() {
        Embed.Builder builder = Embed.BUILDER().setTitle(this.title).setDescription(this.description).setUrl(this.url == null ? null : this.url.toExternalForm()).setTimestamp(this.timestamp).setColor(this.color).setFooter(this.footer).setImage(this.image).setThumbnail(this.thumbnail).setAuthor(this.author);
        this.fields.forEach(arg_0 -> ((Embed.Builder)builder).addField(arg_0));
        return builder;
    }

    public Optional<SentEmbed> toSentEmbed() {
        return Optional.empty();
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<URL> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<Color> getColor() {
        return Optional.ofNullable(this.color);
    }

    public Optional<EmbedDraft.Footer> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    public Optional<EmbedDraft.Image> getImage() {
        return Optional.ofNullable(this.image);
    }

    public Optional<EmbedDraft.Thumbnail> getThumbnail() {
        return Optional.ofNullable(this.thumbnail);
    }

    public Optional<EmbedDraft.Author> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public List<EmbedDraft.Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public ObjectNode toJsonNode(ObjectNode object) {
        String footerText = null;
        String footerIconUrl = null;
        String imageUrl = null;
        String authorName = null;
        String authorUrl = null;
        String authorIconUrl = null;
        String thumbnailUrl = null;
        FileContainer footerIconContainer = null;
        FileContainer imageContainer = null;
        FileContainer authorIconContainer = null;
        FileContainer thumbnailContainer = null;
        if (this.footer != null) {
            footerText = this.footer.getText();
            footerIconUrl = this.footer.getIconUrl().map(URL::toExternalForm).orElse(null);
            footerIconContainer = this.footer.getContainer();
        }
        if (this.image != null) {
            imageUrl = this.image.getUrl().map(URL::toExternalForm).orElse(null);
            imageContainer = this.image.getContainer();
        }
        if (this.author != null) {
            authorName = this.author.getName();
            authorUrl = this.author.getUrl().map(URL::toExternalForm).orElse(null);
            authorIconUrl = this.author.getIconUrl().map(URL::toExternalForm).orElse(null);
            authorIconContainer = this.author.getContainer();
        }
        if (this.thumbnail != null) {
            thumbnailUrl = this.thumbnail.getUrl().map(URL::toExternalForm).orElse(null);
            thumbnailContainer = this.thumbnail.getContainer();
        }
        object.put("type", "rich");
        if (this.title != null && !this.title.equals("")) {
            object.set("title", JsonHelper.nodeOf((Object)this.title));
        }
        if (this.description != null && !this.description.equals("")) {
            object.set("description", JsonHelper.nodeOf((Object)this.description));
        }
        if (this.url != null && !this.url.equals("")) {
            object.set("url", JsonHelper.nodeOf((Object)this.url));
        }
        if (this.color != null) {
            object.set("color", JsonHelper.nodeOf((Object)(this.color.getRGB() & 0xFFFFFF)));
        }
        if (this.timestamp != null) {
            object.set("timestamp", JsonHelper.nodeOf((Object)DateTimeFormatter.ISO_INSTANT.format(this.timestamp)));
        }
        if (footerText != null && !footerText.equals("") || footerIconUrl != null && !footerIconUrl.equals("")) {
            ObjectNode footer = object.putObject("footer");
            if (footerText != null && !footerText.equals("")) {
                footer.set("text", JsonHelper.nodeOf((Object)footerText));
            }
            if (footerIconUrl != null && !footerIconUrl.equals("")) {
                footer.set("icon_url", JsonHelper.nodeOf((Object)footerIconUrl));
            }
            if (footerIconContainer != null) {
                footer.set("icon_url", JsonHelper.nodeOf((Object)("attachment://" + footerIconContainer.getFullName())));
            }
        }
        if (imageUrl != null && !imageUrl.equals("")) {
            object.putObject("image").set("url", JsonHelper.nodeOf((Object)imageUrl));
        }
        if (imageContainer != null) {
            object.putObject("image").set("url", JsonHelper.nodeOf((Object)("attachment://" + imageContainer.getFullName())));
        }
        if (authorName != null && !authorName.equals("")) {
            ObjectNode author = object.putObject("author");
            author.put("name", authorName);
            if (authorUrl != null && !authorUrl.equals("")) {
                author.set("url", JsonHelper.nodeOf((Object)authorUrl));
            }
            if (authorIconUrl != null && !authorIconUrl.equals("")) {
                author.set("icon_url", JsonHelper.nodeOf((Object)authorIconUrl));
            }
            if (authorIconContainer != null) {
                author.set("url", JsonHelper.nodeOf((Object)("attachment://" + authorIconContainer.getFullName())));
            }
        }
        if (thumbnailUrl != null && !thumbnailUrl.equals("")) {
            object.putObject("thumbnail").set("url", JsonHelper.nodeOf((Object)thumbnailUrl));
        }
        if (thumbnailContainer != null) {
            object.putObject("thumbnail").set("url", JsonHelper.nodeOf((Object)("attachment://" + thumbnailContainer.getFullName())));
        }
        if (this.fields.size() > 0) {
            ArrayNode jsonFields = object.putArray("fields");
            for (EmbedDraft.Field field : this.fields) {
                ObjectNode jsonField = jsonFields.addObject();
                jsonField.set("name", JsonHelper.nodeOf((Object)field.getTitle()));
                jsonField.set("value", JsonHelper.nodeOf((Object)field.getText()));
                jsonField.set("inline", JsonHelper.nodeOf((Object)field.isInline()));
            }
        }
        return object;
    }

    public static class EditableField
    extends Field
    implements EmbedDraft.EditableField {
        public EditableField(EmbedDraft.Field field) {
            super(field.getTitle(), field.getText(), field.isInline());
        }

        public EmbedDraft.EditableField setTitle(String title) {
            this.title = title;
            return this;
        }

        public EmbedDraft.EditableField setText(String text) {
            this.text = text;
            return this;
        }

        public EmbedDraft.EditableField setInline(boolean inline) {
            this.inline = inline;
            return this;
        }
    }

    public static class Field
    implements EmbedDraft.Field {
        String title;
        String text;
        boolean inline;

        public Field(String title, String text, boolean inline) {
            this.title = title;
            this.text = text;
            this.inline = inline;
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }

        public boolean isInline() {
            return this.inline;
        }

        public int getTotalCharCount() {
            return this.title.length() + this.text.length();
        }
    }

    public static class Author
    implements EmbedDraft.Author {
        private final String name;
        private final URL url;
        private final URL iconUrl;

        public Author(String name, String url, String iconUrl) {
            this.name = name;
            this.url = UrlHelper.orNull((String)url);
            this.iconUrl = UrlHelper.orNull((String)iconUrl);
        }

        public String getName() {
            return this.name;
        }

        public Optional<URL> getUrl() {
            return Optional.ofNullable(this.url);
        }

        public Optional<URL> getIconUrl() {
            return Optional.ofNullable(this.iconUrl);
        }

        public Container getContainer() {
            return null;
        }
    }

    public static class Thumbnail
    implements EmbedDraft.Thumbnail {
        private final URL url;

        public Thumbnail(String url) {
            this.url = UrlHelper.require((String)url);
        }

        public Optional<URL> getUrl() {
            return Optional.ofNullable(this.url);
        }

        public Container getContainer() {
            return null;
        }
    }

    public static class Image
    implements EmbedDraft.Image {
        private final URL url;

        public Image(String url) {
            this.url = UrlHelper.require((String)url);
        }

        public Optional<URL> getUrl() {
            return Optional.ofNullable(this.url);
        }

        public Container getContainer() {
            return null;
        }
    }

    public static class Footer
    implements EmbedDraft.Footer {
        private final String name;
        private final URL url;

        public Footer(String name, String iconUrl) {
            this.name = name;
            this.url = UrlHelper.orNull((String)iconUrl);
        }

        public String getText() {
            return this.name;
        }

        public Optional<URL> getIconUrl() {
            return Optional.ofNullable(this.url);
        }

        public Container getContainer() {
            return null;
        }
    }
}

