/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message.embed;

import de.kaleidox.crystalshard.internal.items.message.embed.EmbedDraftInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;

public class EmbedBuilderInternal
implements Embed.Builder {
    private static final Logger logger = new Logger(EmbedBuilderInternal.class);
    protected String title;
    protected String description;
    protected URL url;
    protected Instant timestamp;
    protected Color color;
    protected EmbedDraft.Footer footer;
    protected EmbedDraft.Image image;
    protected EmbedDraft.Thumbnail thumbnail;
    protected EmbedDraft.Author author;
    protected ArrayList<EmbedDraft.Field> fields = new ArrayList();
    protected boolean ignoreFieldCount = false;
    private int charCounter = 0;

    public Embed.Builder setTitle(String title) {
        this.charCounter += title.length();
        this.testCharCounter();
        if (title.length() > 256) {
            throw new IllegalArgumentException("Title length must not exceed 256 Characters!");
        }
        this.title = title;
        return this;
    }

    public Embed.Builder setDescription(String description) {
        this.charCounter += description.length();
        this.testCharCounter();
        if (description.length() > 2048) {
            throw new IllegalArgumentException("Description length must not exceed 2048Characters!");
        }
        this.description = description;
        return this;
    }

    public Embed.Builder setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            logger.exception((Throwable)e);
            this.url = null;
        }
        return this;
    }

    public Embed.Builder setColor(Color color) {
        this.color = color;
        return this;
    }

    public Embed.Builder addField(EmbedDraft.Field field) {
        Objects.requireNonNull(field);
        this.charCounter = this.charCounter + field.getText().length() + field.getTitle().length();
        this.testCharCounter();
        if (this.ignoreFieldCount || this.fields.size() >= 25) {
            throw new IllegalArgumentException("Field amount must not exceed 25!");
        }
        if (field.getTitle().isEmpty()) {
            throw new IllegalArgumentException("Field title must not be blank!");
        }
        if (field.getTitle().length() > 256) {
            throw new IllegalArgumentException("Field title must not exceed 256 characters!");
        }
        if (field.getText().isEmpty()) {
            throw new IllegalArgumentException("Field text must not be blank!");
        }
        if (field.getText().length() > 1024) {
            throw new IllegalArgumentException("Field text must not exceed 1024 characters!");
        }
        this.fields.add(field);
        return this;
    }

    public Embed.Builder removeAllFields() {
        this.fields.clear();
        return this;
    }

    public Collection<EmbedDraft.Field> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public EmbedDraft build() {
        return new EmbedDraftInternal(this.title, this.description, this.url, this.timestamp, this.color, this.footer, this.image, this.thumbnail, this.author, this.fields);
    }

    public CompletableFuture<Message> send(MessageReciever sendTo) {
        return sendTo.sendMessage(this.build());
    }

    public Embed.Builder setTimestamp(Instant time) {
        this.timestamp = time;
        return this;
    }

    public Embed.Builder setFooter(EmbedDraft.Footer footer) {
        this.charCounter += footer.getText().length();
        this.testCharCounter();
        if (footer.getText().length() > 2048) {
            throw new IllegalArgumentException("Footer text must not exceed 2048 characters!");
        }
        this.footer = footer;
        return this;
    }

    public Embed.Builder setImage(EmbedDraft.Image image) {
        this.image = image;
        return this;
    }

    public Embed.Builder setThumbnail(EmbedDraft.Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public Embed.Builder setAuthor(EmbedDraft.Author author) {
        this.charCounter += author.getName().length();
        this.testCharCounter();
        if (author.getName().length() > 256) {
            throw new IllegalArgumentException("Author name must not exceed 256 characters!");
        }
        this.author = author;
        return this;
    }

    public Embed.Builder addField(String title, String text, boolean inline) {
        Objects.requireNonNull(title, "Embed field title must not be null.");
        Objects.requireNonNull(text, "Embed field text must not be null.");
        return this.addField(new EmbedDraftInternal.Field(title, text, inline));
    }

    public Embed.Builder updateFields(Predicate<EmbedDraft.Field> predicate, Function<EmbedDraft.EditableField, EmbedDraft.Field> updater) {
        for (int i = 0; i < this.fields.size(); ++i) {
            EmbedDraft.Field field = this.fields.get(i);
            if (!predicate.test(field)) continue;
            this.fields.set(i, updater.apply((EmbedDraft.EditableField)field.toEditableField().get()));
        }
        return this;
    }

    private void testCharCounter() {
        if (this.charCounter > 6000) {
            throw new IllegalArgumentException("Total embed characters must not exceed 6000 characters!");
        }
    }
}

