/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.message;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.Mentionable;
import de.kaleidox.crystalshard.main.items.channel.TextChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.MessageReciever;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.message.embed.EmbedDraft;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.JsonHelper;
import java.util.concurrent.CompletableFuture;

public class MessageModifier {

    public static class Builder
    implements Message.Builder {
        private final StringBuilder sb = new StringBuilder();
        private EmbedDraft draft = null;

        public Builder() {
            this(null);
        }

        public Builder(Message fromMessage) {
            if (fromMessage != null) {
                this.addText(fromMessage.getContent());
                fromMessage.getEmbed().map(Embed::toEmbedDraft).ifPresent(this::setEmbed);
            }
        }

        public Message.Builder addText(String text) {
            this.sb.append(text);
            return this;
        }

        public Message.Builder addMention(Mentionable mentionable) {
            this.sb.append(mentionable.getMentionTag());
            return this;
        }

        public Message.Builder addEmoji(Emoji emoji) {
            this.sb.append(emoji.toDiscordPrintable());
            return this;
        }

        public Message.Builder setEmbed(EmbedDraft embed) {
            this.draft = embed;
            return this;
        }

        public CompletableFuture<Message> send(MessageReciever target) {
            Discord discord = target.getDiscord();
            long useId = -1L;
            if (target instanceof TextChannel) {
                TextChannel tc = (TextChannel)target;
                if (!tc.isPrivate() && tc.hasPermission((User)discord.getSelf(), Permission.SEND_MESSAGES)) {
                    return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Sending Message to Text Channel [" + target.getId() + "])", new Permission[]{Permission.SEND_MESSAGES}));
                }
                useId = tc.getId();
            }
            if (target instanceof User) {
                User usr = (User)target;
                useId = (Long)((CompletableFuture)usr.openPrivateChannel().thenApply(DiscordItem::getId)).join();
            }
            assert (useId != -1L) : "Unexpected type: " + target.getClass().getSimpleName();
            return CoreInjector.webRequest(Message.class, (Discord)discord).setMethod(HttpMethod.POST).setUri((RequestURI)DiscordEndpoint.MESSAGE.createUri(new Object[]{useId})).setNode((JsonNode)JsonHelper.objectNode((Object[])new Object[]{"content", this.sb.toString(), "embed", this.draft, "file", "content"})).executeAs(node -> (Message)discord.getMessageCache().getOrCreate(new Object[]{discord, node})).whenComplete((message, throwable) -> discord.getTunnelFramework().accept(message, new Object[]{this.draft}));
        }
    }
}

