/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.channel.ChannelBuilderInternal;
import de.kaleidox.crystalshard.internal.items.channel.ChannelUpdaterInternal;
import de.kaleidox.crystalshard.internal.items.channel.TextChannelInternal;
import de.kaleidox.crystalshard.internal.items.permission.PermissionOverrideInternal;
import de.kaleidox.crystalshard.internal.items.server.interactive.InviteInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.ChannelEditTrait;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelCategory;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.interactive.MetaInvite;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.ListHelper;
import de.kaleidox.util.helpers.OptionalHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ServerTextChannelInternal
extends TextChannelInternal
implements ServerTextChannel {
    static final ConcurrentHashMap<Long, ServerTextChannel> instances = new ConcurrentHashMap();
    final List<PermissionOverride> overrides;
    final Server server;
    boolean isNsfw;
    String topic;
    String name;
    ChannelCategory category;

    public ServerTextChannelInternal(Discord discord, Server server, JsonNode data) {
        super(discord, data);
        this.server = server;
        this.overrides = new ArrayList<PermissionOverride>();
        this.updateData(data);
        data.path("permission_overwrites").forEach(node -> this.overrides.add(new PermissionOverrideInternal(discord, server, (JsonNode)node)));
        instances.put(this.id, this);
    }

    @Override
    public Set<EditTrait<Channel>> updateData(JsonNode data) {
        HashSet<EditTrait<Channel>> traits = new HashSet<EditTrait<Channel>>();
        if (this.isNsfw != data.path("nsfw").asBoolean(this.isNsfw)) {
            this.isNsfw = data.get("nsfw").asBoolean();
            traits.add((EditTrait<Channel>)ChannelEditTrait.NSFW_FLAG);
        }
        if (this.topic == null || !this.topic.equals(data.path("topic").asText(this.topic))) {
            this.topic = data.get("topic").asText();
            traits.add((EditTrait<Channel>)ChannelEditTrait.TOPIC);
        }
        if (this.name == null || !this.name.equals(data.path("name").asText(this.name))) {
            this.name = data.get("name").asText();
            traits.add((EditTrait<Channel>)ChannelEditTrait.NAME);
        }
        if (this.category == null || this.category == null && data.has("parent_id")) {
            long parentId = data.path("parent_id").asLong(-1L);
            this.category = parentId == -1L ? null : (ChannelCategory)((Channel)this.discord.getChannelCache().getOrRequest((Object)parentId, (Object)parentId)).toChannelCategory().orElse(null);
        } else if (this.category != null && !data.has("parent_id")) {
            this.category = null;
        }
        ArrayList overrides = new ArrayList();
        data.path("permission_overwrites").forEach(node -> overrides.add(new PermissionOverrideInternal(this.discord, this.server, (JsonNode)node)));
        if (!ListHelper.equalContents(overrides, this.overrides)) {
            this.overrides.clear();
            this.overrides.addAll(overrides);
            traits.add((EditTrait<Channel>)ChannelEditTrait.PERMISSION_OVERWRITES);
        }
        return traits;
    }

    public Server getServer() {
        return this.server;
    }

    public Optional<ChannelCategory> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public List<PermissionOverride> getPermissionOverrides() {
        return this.overrides;
    }

    public CompletableFuture<Collection<MetaInvite>> getChannelInvites() {
        if (!this.hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot get channel invite!", new Permission[]{Permission.MANAGE_CHANNELS}));
        }
        WebRequest request = CoreInjector.webRequest((Discord)this.discord);
        return request.setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CHANNEL_INVITE.createUri(new Object[]{this.id})).executeAs(data -> {
            ArrayList list = new ArrayList();
            data.forEach(invite -> list.add(new InviteInternal.Meta(this.discord, (JsonNode)invite)));
            return list;
        });
    }

    public ServerChannel.InviteBuilder getInviteBuilder() {
        return new ChannelBuilderInternal.ChannelInviteBuilder((ServerChannel)this);
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return 0;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isNsfw() {
        return this.isNsfw;
    }

    public ServerTextChannel.Updater getUpdater() {
        return new ChannelUpdaterInternal.ServerTextChannelUpdater(this.discord, this);
    }

    public boolean hasPermission(User user, Permission permission) {
        return OptionalHelper.or(this.overrides.stream().filter(override -> override.getParent() != null).filter(override -> override.getParent().equals((DiscordItem)user)).map(override -> override.getAllowed().contains((Object)permission)).findAny(), () -> OptionalHelper.or(this.getCategory().flatMap(channelCategory -> channelCategory.getPermissionOverrides().stream().filter(override -> override.getParent() != null).filter(override -> override.getParent().equals((DiscordItem)user)).findAny()).map(override -> override.getAllowed().contains((Object)permission)), () -> Optional.of(this.toServerChannel().map(ServerChannel::getServer).orElseThrow(AssertionError::new).getEveryoneRole().getPermissions().contains((Object)Permission.SEND_MESSAGES)))).orElse(true);
    }
}

