/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.items.permission.PermissionOverrideInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelCategory;
import de.kaleidox.crystalshard.main.items.channel.ChannelType;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerVoiceChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.util.helpers.FutureHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ChannelUpdaterInternal {

    public static class ServerVoiceChannelUpdater
    extends ServerChannelUpdater<ServerVoiceChannel.Updater, ServerVoiceChannel>
    implements ServerVoiceChannel.Updater {
        protected Integer bitrate;
        protected Integer limit;

        protected ServerVoiceChannelUpdater(Discord discord, ServerVoiceChannel channel) {
            super(discord, (ServerChannel)channel, ChannelType.GUILD_VOICE);
            this.setSuperType(this);
        }

        public ServerVoiceChannel.Updater setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return (ServerVoiceChannel.Updater)this.superType;
        }

        public ServerVoiceChannel.Updater setUserLimit(int limit) {
            this.limit = limit;
            return (ServerVoiceChannel.Updater)this.superType;
        }

        public CompletableFuture<ServerVoiceChannel> update() {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4;
            Object[] objectArray5;
            if (!((Server)this.channel.getServerOfChannel().orElseThrow(AssertionError::new)).hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot update channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            WebRequest webRequest = CoreInjector.webRequest(ServerVoiceChannel.class, (Discord)this.discord).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.CHANNEL.createUri(new Object[]{this.channel}));
            Object[] objectArray6 = new Object[7];
            if (this.name != null) {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "name";
                objectArray5 = objectArray7;
                objectArray7[1] = this.name;
            } else {
                objectArray5 = objectArray6[0] = new Object[]{};
            }
            if (this.position != null) {
                Object[] objectArray8 = new Object[2];
                objectArray8[0] = "position";
                objectArray4 = objectArray8;
                objectArray8[1] = this.position;
            } else {
                objectArray4 = objectArray6[1] = new Object[]{};
            }
            if (this.bitrate != null) {
                Object[] objectArray9 = new Object[2];
                objectArray9[0] = "bitrate";
                objectArray3 = objectArray9;
                objectArray9[1] = this.bitrate;
            } else {
                objectArray3 = objectArray6[2] = new Object[]{};
            }
            if (this.limit != null) {
                Object[] objectArray10 = new Object[2];
                objectArray10[0] = "user_limit";
                objectArray2 = objectArray10;
                objectArray10[1] = this.limit;
            } else {
                objectArray2 = objectArray6[3] = new Object[]{};
            }
            if (this.category != null) {
                Object[] objectArray11 = new Object[2];
                objectArray11[0] = "parent_id";
                objectArray = objectArray11;
                objectArray11[1] = this.category.getId();
            } else {
                objectArray = new Object[]{};
            }
            objectArray6[4] = objectArray;
            objectArray6[5] = "permission_overwrites";
            objectArray6[6] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray6).executeAs(node -> (ServerVoiceChannel)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toServerVoiceChannel().orElseThrow(AssertionError::new));
        }
    }

    public static class ServerTextChannelUpdater
    extends ServerChannelUpdater<ServerTextChannel.Updater, ServerTextChannel>
    implements ServerTextChannel.Updater {
        protected String topic;
        protected Boolean nsfw;

        protected ServerTextChannelUpdater(Discord discord, ServerTextChannel channel) {
            super(discord, (ServerChannel)channel, ChannelType.GUILD_TEXT);
            this.setSuperType(this);
        }

        public ServerTextChannel.Updater setTopic(String topic) {
            this.topic = topic;
            return (ServerTextChannel.Updater)this.superType;
        }

        public ServerTextChannel.Updater setNSFW(boolean nsfw) {
            this.nsfw = nsfw;
            return (ServerTextChannel.Updater)this.superType;
        }

        public CompletableFuture<ServerTextChannel> update() {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4;
            Object[] objectArray5;
            if (!((Server)this.channel.getServerOfChannel().orElseThrow(AssertionError::new)).hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot update channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            WebRequest webRequest = CoreInjector.webRequest(ServerTextChannel.class, (Discord)this.discord).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.CHANNEL.createUri(new Object[]{this.channel}));
            Object[] objectArray6 = new Object[7];
            if (this.name != null) {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "name";
                objectArray5 = objectArray7;
                objectArray7[1] = this.name;
            } else {
                objectArray5 = objectArray6[0] = new Object[]{};
            }
            if (this.topic != null) {
                Object[] objectArray8 = new Object[2];
                objectArray8[0] = "topic";
                objectArray4 = objectArray8;
                objectArray8[1] = this.topic;
            } else {
                objectArray4 = objectArray6[1] = new Object[]{};
            }
            if (this.position != null) {
                Object[] objectArray9 = new Object[2];
                objectArray9[0] = "position";
                objectArray3 = objectArray9;
                objectArray9[1] = this.position;
            } else {
                objectArray3 = objectArray6[2] = new Object[]{};
            }
            if (this.nsfw != null) {
                Object[] objectArray10 = new Object[2];
                objectArray10[0] = "nsfw";
                objectArray2 = objectArray10;
                objectArray10[1] = this.nsfw;
            } else {
                objectArray2 = objectArray6[3] = new Object[]{};
            }
            if (this.category != null) {
                Object[] objectArray11 = new Object[2];
                objectArray11[0] = "parent_id";
                objectArray = objectArray11;
                objectArray11[1] = this.category.getId();
            } else {
                objectArray = new Object[]{};
            }
            objectArray6[4] = objectArray;
            objectArray6[5] = "permission_overwrites";
            objectArray6[6] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray6).executeAs(node -> (ServerTextChannel)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toServerTextChannel().orElseThrow(AssertionError::new));
        }
    }

    public static class ServerCategoryUpdater
    extends ServerChannelUpdater<ServerChannel.Updater, ChannelCategory> {
        protected ServerCategoryUpdater(Discord discord, ChannelCategory channel) {
            super(discord, (ServerChannel)channel, ChannelType.GUILD_CATEGORY);
            this.setSuperType(this);
            this.category = null;
        }

        @Override
        public ServerChannel.Updater setCategory(ChannelCategory category) {
            throw new UnsupportedOperationException("Cannot change the category of a category!");
        }

        public CompletableFuture<ChannelCategory> update() {
            Object[] objectArray;
            Object[] objectArray2;
            if (!((Server)this.channel.getServerOfChannel().orElseThrow(AssertionError::new)).hasPermission(this.discord, Permission.MANAGE_CHANNELS)) {
                return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot update channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
            }
            WebRequest webRequest = CoreInjector.webRequest(ChannelCategory.class, (Discord)this.discord).setMethod(HttpMethod.PATCH).setUri((RequestURI)DiscordEndpoint.CHANNEL.createUri(new Object[]{this.channel}));
            Object[] objectArray3 = new Object[4];
            if (this.name != null) {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = "name";
                objectArray2 = objectArray4;
                objectArray4[1] = this.name;
            } else {
                objectArray2 = objectArray3[0] = new Object[]{};
            }
            if (this.position != null) {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = "position";
                objectArray = objectArray5;
                objectArray5[1] = this.position;
            } else {
                objectArray = new Object[]{};
            }
            objectArray3[1] = objectArray;
            objectArray3[2] = "permission_overwrites";
            objectArray3[3] = this.overrides.stream().map(PermissionOverrideInternal.class::cast).map(PermissionOverrideInternal::toJsonNode).collect(Collectors.toList());
            return webRequest.setNode(objectArray3).executeAs(node -> (ChannelCategory)((Channel)this.discord.getChannelCache().getOrCreate(new Object[]{this.discord, node})).toChannelCategory().orElseThrow(AssertionError::new));
        }
    }

    public static abstract class ServerChannelUpdater<T, R>
    extends ChannelUpdater<T, R>
    implements ServerChannel.Updater<T, R> {
        protected final ChannelType type;
        protected String name;
        protected Integer position;
        protected ChannelCategory category;
        protected List<PermissionOverride> overrides;

        protected ServerChannelUpdater(Discord discord, ServerChannel channel, ChannelType type) {
            super(discord, (Channel)channel);
            this.type = type;
            this.overrides = new ArrayList<PermissionOverride>();
        }

        public T setName(String name) {
            this.name = name;
            return (T)this.superType;
        }

        public T setPosition(int position) {
            this.position = position;
            return (T)this.superType;
        }

        public T setCategory(ChannelCategory category) {
            this.category = category;
            return (T)this.superType;
        }

        public T modifyOverrides(Consumer<List<PermissionOverride>> overrideModifier) {
            overrideModifier.accept(this.overrides);
            return (T)this.superType;
        }
    }

    public static abstract class ChannelUpdater<T, R>
    implements Channel.Updater<T, R> {
        protected final Discord discord;
        protected final Channel channel;
        protected T superType;

        protected ChannelUpdater(Discord discord, Channel channel) {
            this.discord = discord;
            this.channel = channel;
        }

        public Discord getDiscord() {
            return null;
        }

        protected void setSuperType(T superType) {
            this.superType = superType;
        }
    }
}

