/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordPermissionException;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.handling.listener.channel.ChannelAttachableListener;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelType;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.helpers.FutureHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class ChannelInternal
implements Channel {
    final Discord discord;
    final ChannelType type;
    final boolean isPrivate;
    final long id;
    final List<ListenerManager<? extends ChannelAttachableListener>> listenerManagers;

    ChannelInternal(Discord discord, JsonNode data) {
        this.discord = discord;
        this.id = data.get("id").asLong();
        this.type = ChannelType.getFromId((int)data.get("type").asInt());
        this.isPrivate = this.type == ChannelType.DM || this.type == ChannelType.GROUP_DM;
        this.listenerManagers = new ArrayList<ListenerManager<? extends ChannelAttachableListener>>();
    }

    public abstract Set<EditTrait<Channel>> updateData(JsonNode var1);

    public Discord getDiscord() {
        return this.discord;
    }

    public long getId() {
        return this.id;
    }

    public <C extends ChannelAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance((DiscordInternal)this.discord, listener);
        this.listenerManagers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(ChannelAttachableListener listener) {
        ListenerManagerInternal<ChannelAttachableListener> manager = ListenerManagerInternal.getInstance((DiscordInternal)this.discord, listener);
        return Evaluation.of((boolean)this.listenerManagers.remove(manager));
    }

    public Collection<ListenerManager<? extends ChannelAttachableListener>> getListenerManagers() {
        return this.listenerManagers;
    }

    public Collection<ChannelAttachableListener> getAttachedListeners() {
        return this.listenerManagers.stream().map(ListenerManager::getListener).collect(Collectors.toList());
    }

    public ChannelType getType() {
        return this.type;
    }

    public CompletableFuture<Void> delete() {
        if (!this.hasPermission((User)this.discord.getSelf(), Permission.MANAGE_CHANNELS)) {
            return FutureHelper.failedFuture((Throwable)new DiscordPermissionException("Cannot delete channel!", new Permission[]{Permission.MANAGE_CHANNELS}));
        }
        return CoreInjector.webRequest((Discord)this.discord).setMethod(HttpMethod.DELETE).setUri((RequestURI)DiscordEndpoint.CHANNEL.createUri(new Object[]{this.id})).executeAsVoid();
    }

    public Cache<Channel, Long, Long> getCache() {
        return this.discord.getChannelCache();
    }
}

