/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.items.channel;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.internal.items.channel.ChannelBuilderInternal;
import de.kaleidox.crystalshard.internal.items.channel.ChannelInternal;
import de.kaleidox.crystalshard.internal.items.channel.ChannelUpdaterInternal;
import de.kaleidox.crystalshard.internal.items.permission.PermissionOverrideInternal;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.editevent.enums.ChannelEditTrait;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelCategory;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.permission.Permission;
import de.kaleidox.crystalshard.main.items.permission.PermissionOverride;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.interactive.MetaInvite;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.util.helpers.OptionalHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelCategoryInternal
extends ChannelInternal
implements ChannelCategory {
    static final ConcurrentHashMap<Long, ChannelCategory> instances = new ConcurrentHashMap();
    private final List<PermissionOverride> overrides;
    final Server server;
    String name;

    public ChannelCategoryInternal(Discord discord, Server server, JsonNode data) {
        super(discord, data);
        this.server = server;
        this.name = data.path("name").asText("");
        this.overrides = new ArrayList<PermissionOverride>();
        data.path("permission_overwrites").forEach(node -> this.overrides.add(new PermissionOverrideInternal(discord, server, (JsonNode)node)));
        instances.put(this.id, this);
    }

    @Override
    public Set<EditTrait<Channel>> updateData(JsonNode data) {
        HashSet<EditTrait<Channel>> traits = new HashSet<EditTrait<Channel>>();
        if (!this.name.equals(data.path("name").asText(this.name))) {
            this.name = data.get("name").asText();
            traits.add((EditTrait<Channel>)ChannelEditTrait.NAME);
        }
        return traits;
    }

    public Server getServer() {
        return this.server;
    }

    public Optional<ChannelCategory> getCategory() {
        return Optional.of(this);
    }

    public List<PermissionOverride> getPermissionOverrides() {
        return this.overrides;
    }

    public CompletableFuture<Collection<MetaInvite>> getChannelInvites() {
        return null;
    }

    public ServerChannel.InviteBuilder getInviteBuilder() {
        return new ChannelBuilderInternal.ChannelInviteBuilder((ServerChannel)this);
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return 0;
    }

    public boolean hasPermission(User user, Permission permission) {
        return OptionalHelper.or(this.overrides.stream().filter(override -> override.getParent() != null).filter(override -> override.getParent().equals((DiscordItem)user)).map(override -> override.getAllowed().contains((Object)permission)).findAny(), () -> Optional.of(this.server.getEveryoneRole().getPermissions().contains((Object)permission))).orElse(true);
    }

    public ServerChannel.Updater getUpdater() {
        return new ChannelUpdaterInternal.ServerCategoryUpdater(this.discord, this);
    }
}

