/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.handling.event.message.generic;

import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.internal.handling.event.EventBase;
import de.kaleidox.crystalshard.main.handling.editevent.EditTrait;
import de.kaleidox.crystalshard.main.handling.event.message.generic.MessageEditEvent;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ServerChannel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.embed.SentEmbed;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.user.Author;
import de.kaleidox.crystalshard.main.items.user.AuthorUser;
import java.util.Optional;
import java.util.Set;

public class MessageEditEventInternal
extends EventBase
implements MessageEditEvent {
    private final Message message;
    private final String prevContent;
    private final SentEmbed prevEmbed;
    private final Set<EditTrait<Message>> traits;

    public MessageEditEventInternal(DiscordInternal discordInternal, Message message, Set<EditTrait<Message>> traits, String prevContent, SentEmbed prevEmbed) {
        super(discordInternal);
        this.message = message;
        this.traits = traits;
        this.prevContent = prevContent;
        this.prevEmbed = prevEmbed;
    }

    public Message getMessage() {
        return this.message;
    }

    public Channel getChannel() {
        return this.message.getChannel();
    }

    public Author getMessageAuthor() {
        return this.message.getAuthor();
    }

    public Optional<AuthorUser> getMessageAuthorUser() {
        return this.message.getAuthorAsUser();
    }

    public String getMessageContent() {
        return this.message.getContent();
    }

    public Optional<Server> getServer() {
        return this.message.getChannel().toServerChannel().map(ServerChannel::getServer);
    }

    public Optional<String> getPreviousContent() {
        return Optional.ofNullable(this.prevContent);
    }

    public Optional<SentEmbed> getPreviousEmbed() {
        return Optional.ofNullable(this.prevEmbed);
    }

    public Set<EditTrait<Message>> getEditTraits() {
        return this.traits;
    }
}

