/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal.handling;

import de.kaleidox.crystalshard.internal.DiscordInternal;
import de.kaleidox.crystalshard.main.handling.listener.DiscordAttachableListener;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.ListenerAttachable;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ListenerManagerInternal<T extends Listener>
implements ListenerManager<T> {
    private static final ConcurrentHashMap<Integer, ListenerManagerInternal<? extends Listener>> instances = new ConcurrentHashMap();
    private final DiscordInternal discord;
    private final T listener;
    private final List<ListenerAttachable<T>> attachedTo = new ArrayList<ListenerAttachable<T>>();
    private final List<Runnable> detachRunnables = new ArrayList<Runnable>();
    private boolean enabled;

    ListenerManagerInternal(DiscordInternal discord, T listener) {
        this.discord = discord;
        this.listener = listener;
        instances.putIfAbsent(listener.hashCode(), this);
    }

    public DiscordInternal getDiscord() {
        return this.discord;
    }

    public T getListener() {
        return this.listener;
    }

    public ListenerManager<T> detachNow() {
        this.discord.getAllListenerManagers().stream().filter(manager -> this.listener.getClass().isAssignableFrom(((DiscordAttachableListener)manager.getListener()).getClass())).filter(manager -> this.listener.equals(manager.getListener())).map(ListenerManagerInternal.class::cast).flatMap(manager -> manager.attachedTo.stream()).forEachOrdered(attachable -> attachable.detachListener(this.listener));
        this.detachRunnables.forEach(Runnable::run);
        return this;
    }

    public ListenerManager<T> detachIn(long time, TimeUnit unit) {
        this.discord.getScheduler().schedule(this::detachNow, time, unit);
        return this;
    }

    public ListenerManager<T> onDetach(Runnable runnable) {
        this.detachRunnables.add(runnable);
        return this;
    }

    public ListenerManager<T> enable() {
        this.enabled = true;
        return this;
    }

    public ListenerManager<T> disable() {
        this.enabled = false;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public <C extends ListenerAttachable<T>> void addAttached(C attached) {
        this.attachedTo.add(attached);
    }

    public static <T extends Listener> ListenerManagerInternal<T> getInstance(DiscordInternal discordInternal, T listener) {
        if (instances.containsKey(listener.hashCode())) {
            return instances.get(listener.hashCode());
        }
        return new ListenerManagerInternal<T>(discordInternal, listener);
    }
}

