/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.internal;

import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.concurrent.ThreadPool;
import de.kaleidox.crystalshard.core.net.request.ratelimiting.Ratelimiter;
import de.kaleidox.crystalshard.core.net.socket.WebSocketClient;
import de.kaleidox.crystalshard.internal.handling.ListenerManagerInternal;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.listener.DiscordAttachableListener;
import de.kaleidox.crystalshard.main.handling.listener.ListenerManager;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.role.Role;
import de.kaleidox.crystalshard.main.items.server.Server;
import de.kaleidox.crystalshard.main.items.server.emoji.CustomEmoji;
import de.kaleidox.crystalshard.main.items.user.AccountType;
import de.kaleidox.crystalshard.main.items.user.Self;
import de.kaleidox.crystalshard.main.items.user.User;
import de.kaleidox.crystalshard.util.DiscordUtils;
import de.kaleidox.crystalshard.util.UtilInjector;
import de.kaleidox.util.functional.Evaluation;
import de.kaleidox.util.functional.LivingInt;
import de.kaleidox.util.markers.IDPair;
import de.kaleidox.util.tunnel.TunnelFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DiscordInternal
implements Discord {
    private static final Logger logger = new Logger(DiscordInternal.class);
    private final ThreadPool pool;
    private final String token;
    private final AccountType type;
    private final WebSocketClient webSocket;
    private final Ratelimiter ratelimiter;
    private final List<Server> servers;
    private final DiscordUtils utils;
    private final Collection<ListenerManager<? extends DiscordAttachableListener>> listenerManangers = new ArrayList<ListenerManager<? extends DiscordAttachableListener>>();
    private final int thisShard;
    private final int shardCount;
    private final Self self;
    private final Cache<Server, Long, Long> serverCache;
    private final Cache<User, Long, Long> userCache;
    private final Cache<Role, Long, IDPair> roleCache;
    private final Cache<Channel, Long, Long> channelCache;
    private final Cache<Message, Long, IDPair> messageCache;
    private final Cache<CustomEmoji, Long, IDPair> emojiCache;
    private final TunnelFramework tunnelFramework;
    private CompletableFuture<Self> selfFuture;
    private boolean init = false;
    private LivingInt serversInit;

    public DiscordInternal(String token, AccountType type, Integer thisShard, Integer ShardCount) {
        Logger.addBlankedWord((String)token);
        this.serverCache = CoreInjector.serverCache((Discord)this);
        this.userCache = CoreInjector.userCache((Discord)this);
        this.roleCache = CoreInjector.roleCache((Discord)this);
        this.channelCache = CoreInjector.channelCache((Discord)this);
        this.messageCache = CoreInjector.messageCache((Discord)this);
        this.emojiCache = CoreInjector.emojiCache((Discord)this);
        this.selfFuture = new CompletableFuture();
        this.tunnelFramework = new TunnelFramework();
        this.serversInit = new LivingInt(5, 0, -1, 1L, TimeUnit.SECONDS);
        this.serversInit.onStopHit(() -> {
            this.init = true;
        });
        this.thisShard = thisShard;
        this.shardCount = ShardCount;
        this.pool = (ThreadPool)CoreInjector.newInstance(ThreadPool.class, (Object[])new Object[]{this});
        this.token = token;
        this.type = type;
        this.ratelimiter = (Ratelimiter)CoreInjector.newInstance(Ratelimiter.class, (Object[])new Object[]{this});
        this.webSocket = (WebSocketClient)CoreInjector.newInstance(WebSocketClient.class, (Object[])new Object[]{this});
        this.utils = (DiscordUtils)UtilInjector.newInstance(DiscordUtils.class, (Object[])new Object[]{this});
        this.servers = new ArrayList<Server>();
        logger.info((Object)"Waiting for initialization to finish...");
        this.self = this.selfFuture.join();
        logger.info((Object)("Discord connection for user " + this.self.getDiscriminatedName() + " is ready!"));
    }

    public String getPrefixedToken() {
        return this.type.getPrefix() + this.token;
    }

    public boolean initFinished() {
        return this.init;
    }

    public int getShardId() {
        return this.thisShard;
    }

    public int getShards() {
        return this.shardCount;
    }

    public DiscordUtils getUtilities() {
        return this.utils;
    }

    public Optional<Channel> getChannelById(long id) {
        return this.servers.stream().flatMap(server -> server.getChannels().stream()).filter(channel -> channel.getId() == id).map(Channel.class::cast).findAny();
    }

    public Optional<User> getUserById(long id) {
        return Optional.empty();
    }

    public Self getSelf() {
        return this.self;
    }

    public Optional<Server> getServerById(long id) {
        return this.servers.stream().filter(server -> server.getId() == id).findAny();
    }

    public Executor getExecutor() {
        return this.getThreadPool().getExecutor();
    }

    public WebSocketClient getWebSocket() {
        return this.webSocket;
    }

    public Ratelimiter getRatelimiter() {
        return this.ratelimiter;
    }

    public Collection<Server> getServers() {
        return this.servers;
    }

    public Collection<User> getUsers() {
        return null;
    }

    public int getServerCount() {
        return 0;
    }

    public int getUserCount() {
        return 0;
    }

    public Cache<Server, Long, Long> getServerCache() {
        return this.serverCache;
    }

    public Cache<User, Long, Long> getUserCache() {
        return this.userCache;
    }

    public Cache<Role, Long, IDPair> getRoleCache() {
        return this.roleCache;
    }

    public Cache<Channel, Long, Long> getChannelCache() {
        return this.channelCache;
    }

    public Cache<Message, Long, IDPair> getMessageCache() {
        return this.messageCache;
    }

    public Cache<CustomEmoji, Long, IDPair> getEmojiCache() {
        return this.emojiCache;
    }

    public ThreadPool getThreadPool() {
        return this.pool;
    }

    public TunnelFramework getTunnelFramework() {
        return this.tunnelFramework;
    }

    public Discord getDiscord() {
        return this;
    }

    public long getId() {
        return 0L;
    }

    public <C extends DiscordAttachableListener> ListenerManager<C> attachListener(C listener) {
        ListenerManagerInternal<C> manager = ListenerManagerInternal.getInstance(this, listener);
        this.listenerManangers.add(manager);
        return manager;
    }

    public Evaluation<Boolean> detachListener(DiscordAttachableListener listener) {
        return Evaluation.of((boolean)this.listenerManangers.removeIf(manager -> ((DiscordAttachableListener)manager.getListener()).equals(listener)));
    }

    public Collection<ListenerManager<? extends DiscordAttachableListener>> getListenerManagers() {
        return this.listenerManangers;
    }

    public Collection<DiscordAttachableListener> getAttachedListeners() {
        return this.listenerManangers.stream().map(ListenerManager::getListener).collect(Collectors.toList());
    }

    public String toString() {
        return "Discord Connection to " + this.self;
    }

    public Collection<ListenerManager<? extends DiscordAttachableListener>> getAllListenerManagers() {
        return this.listenerManangers;
    }

    public CompletableFuture<Self> getSelfFuture() {
        return this.selfFuture;
    }

    public synchronized void addServer(Server server) {
        DiscordInternal.assureList(this.servers, ArrayList::new).add(server);
        this.serversInit.set(5);
    }

    private static <T, C extends Collection<T>> C assureList(C ptr, Supplier<C> supp) {
        return (C)(ptr == null ? (ptr = (Collection)supp.get()) : ptr);
    }
}

